
#include "Ultrasonic.h"

Ultrasonic ultrasonic(7); // capteur de distance

int Slider1 = 0;    // Slider 1 : xPerso
byte Slider1Pin = A0;
byte Slider2Pin = A1;   // Slider 2 : yPerso
int Potentiometre1 = 0;    // Potentiomètre 1 : ChoixPerso
byte Potentiometre1Pin = A2;
int Potentiometre2 = 0;    // Potentiomètre 2 : CouleurPerso
byte Potentiometre2Pin = A3;
int ChoixMesureDistance = 0;  // Bouton poussoir - 0 : mesure de distance par slider 2 (yPerso). 1 : Mesure de distance par le capteur de distance
byte boutonPoussoirPin = 2; // broche de lecture du bouton poussoir

int Distance = 0; // distance lue sur le capteur de distance // Attention MeasureInCentimeters() renvoie un type "long"
int inByte = 0;         // incoming serial byte

byte ledPin = 8; // broche de commande de la LED


byte etat_bouton = 0; //La variable « etat_bouton » mémorise l’état HIGH ou LOW de la pate d’entrée
byte old_etat_bouton = 0; //La variable « old_etat_bouton » mémorise l’ancien état de la variable « etat_bouton »
byte etat_led = 0; //La variable « etat_led » mémorise l’état 1 (allumée) ou 0 (éteinte) de la led.

boolean debug = false;
boolean debug_Com_Serial = false;


void setup() {
  // start serial port at 9600 bps:
  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }

  pinMode(boutonPoussoirPin, INPUT);   // digital sensor is on digital pin D2
  pinMode(ledPin, OUTPUT); // LED sur D7
  if (!debug) {
    establishContact();  // send a byte to establish contact until receiver responds
  }
}

void loop() {
  gestionBouton();

  // Si une donnée arrive dans le port série venant de processing = LIre les nouvelles valeurs des différents capteurs
  if (!debug) { // mode normal
    if (Serial.available() > 0) {
      //  lecture de la donnée sur le port série : lettre A
      inByte = Serial.read();
      if (inByte == 'A') { // vérification du caractère envoyé par Processing
        // mesure sur les différents capteurs
        gestionCapteurs();
        // Envoi des valeurs lues sur les différents capteurs vers Processing
       envoiMesureVersProcessing();

        if (debug_Com_Serial) { ///// Debug
          envoiMesureSurPortSerial();
        }
      }
    }
  }
  else { // mode debug
    // mesure sur les différents capteurs
    gestionCapteurs();
    // Envoi des valeurs lues sur les différents capteurs
    envoiMesureSurPortSerial();
    delay(500);
  }
}

void establishContact() {
  while (Serial.available() <= 0) {
    Serial.print('A');   // send a capital A
    delay(300);
  }
}

void gestionBouton() {
  // mesure de l'état du bouton
  etat_bouton = digitalRead(boutonPoussoirPin); // lit et mémorise l’état en entrée de la pate 2

  if ((etat_bouton == LOW) && (old_etat_bouton == HIGH)) {
    // si l’entrée 2 est à l’état LOW (bouton appuyé) et que juste précédemment le bouton est ouvert
    etat_led = 1 - etat_led ; // inverse l’état de la led
    delay(10); // patienter 10ms pour éviter les rebonds avant d’allumer la led
  }
  old_etat_bouton = etat_bouton; // sauvegarde la nouvelle valeur
  ChoixMesureDistance = etat_led ; // choix du capteur de distance Ultrason ou du Slider
  if (etat_led == 1) {//si la led doit être allumée
    digitalWrite(ledPin, HIGH); // allumer la LED
  }
  else { // si la led est éteinte
    digitalWrite(ledPin, LOW); // éteindre la LED
  }
}

void gestionCapteurs() {
  // lecture des données sur les différents capteurs. On divise par 4 pour ramener la valeur entre 0 et 255
  Potentiometre1 = map(analogRead(Potentiometre1Pin), 0, 1023, 0, 3.5); //ChoixPerso : 0, 1, 2 (3 personnages). Attention : on a mis 3.5 car sinon, le déclenchement du 2ième personage s'effectuer trop tardivement
  // delay 10ms to let the ADC recover:
  delay(10);

  Potentiometre2 = analogRead(Potentiometre2Pin) / 4; //CouleurPerso
  // delay 10ms to let the ADC recover:
  delay(10);

  Slider1 = analogRead(Slider1Pin) / 4; // xPerso
  // delay 10ms to let the ADC recover:
  delay(10);

  // lecture de la distance avec le capteur ultrason ou le Slider 2
  if (ChoixMesureDistance == 1) { // Capteur de distance ultrason
    Distance = map(ultrasonic.MeasureInCentimeters(), 0, 400, 0, 255); // mesure de la distanceentre 0 et 400cm et ramener cette valeur entre 0 et 255
  }
  else {
    Distance = analogRead(Slider2Pin) / 4; //yPerso lu sur Slider 2
  }
}

void envoiMesureVersProcessing() {
  Serial.write(Potentiometre1); //ChoixPerso
  Serial.write(Potentiometre2); //CouleurPerso
  Serial.write(Slider1); // xPerso
  Serial.write(Distance);//distance - y Perso
}

void envoiMesureSurPortSerial() {
  Serial.println("");
  Serial.print("etat_led = ");
  Serial.print(etat_led); //etat_led
  Serial.print("   ChoixPerso = ");
  Serial.print(Potentiometre1); //ChoixPerso
  Serial.print("   CouleurPerso = ");
  Serial.print(Potentiometre2); //CouleurPerso
  Serial.print("   xPerso = ");
  Serial.print(Slider1); // xPerso
  Serial.print("   yPerso = ");
  Serial.print(Distance);//distance - yPerso
  Serial.println("");
}
