import processing.serial.*;

int bgcolor;			     // Background color
int fgcolor=255;			     // Fill color
Serial myPort;                       // The serial port
int NbData = 4; // nombre de données à récupérer de la carte Arduino
int[] serialInArray = new int[NbData];    // Where we'll put what we receive
int serialCount = 0;                 // A count of how many bytes we receive
int xPerso, yPerso, ChoixPerso, CouleurPerso, ChoixMesureDistance, Distance, sPerso;		             // Starting position of the ball
boolean firstContact = false;        // Whether we've heard from the microcontroller
PImage loubon;
PImage bouvier;


void setup() {
  size(1000,570);  // Stage size
  noStroke();      // No border on the next thing drawn
  colorMode(HSB);

  // Initialisation des variables
  ChoixPerso=0; // Potentiomètre 1
  CouleurPerso = 0; //Potentiomètre 2
  xPerso = width/2; // Slider 1
  yPerso = height/2; // Slider 2 - Distance
  sPerso = 250; //Taille du personnage
  bouvier = loadImage("Images/Bouviercarre.png"); //Image du personnage
  loubon= loadImage("Images/Loubon_-_Vue_de_Marseille.jpg"); // Image du fond

  // Print a list of the serial ports, for debugging purposes:
  printArray(Serial.list());

  // I know that the first port in the serial list on my mac
  // is always my  FTDI adaptor, so I open Serial.list()[0].
  // On Windows machines, this generally opens COM1.
  // Open whatever port is the one you're using.
  String portName = Serial.list()[0];
  myPort = new Serial(this, portName, 9600);
}

void draw() { /////////////////////////////////////// r@Lise : ajouter le graphisme...
  background(loubon);
  //fill(fgcolor);
  // Draw the shape
  //ellipse(xPerso, yPerso, 20, 20);

  if (ChoixPerso == 0) {
    bouvier = loadImage("Images/Bouviercarre.png");
  }
  if (ChoixPerso == 1){
   bouvier = loadImage("Images/Arbrecarre.png"); 
  }
  if (ChoixPerso == 2){
   bouvier = loadImage("Images/Vachecarre.png"); 
  }
  image(bouvier, xPerso, yPerso, sPerso, sPerso);

}
//for (int i = 0; i < img.pixels.length; i++) {
//  img.pixels[i] = color(0, 90, 102, i % img.width * 2); 
//}
void serialEvent(Serial myPort) { // gestion des données envoyées par la carte
  // read a byte from the serial port:
  int inByte = myPort.read();
  // if this is the first byte received, and it's an A,
  // clear the serial buffer and note that you've
  // had first contact from the microcontroller. 
  // Otherwise, add the incoming byte to the array:
  if (firstContact == false) {
    if (inByte == 'A') { 
      myPort.clear();          // clear the serial port buffer
      firstContact = true;     // you've had first contact from the microcontroller
      myPort.write('A');       // ask for more
    }
  } else {
    // Add the latest byte from the serial port to array:
    serialInArray[serialCount] = inByte;
    serialCount++;

    // If we have NbData bytes:
    if (serialCount > NbData-1) {
      ChoixPerso=serialInArray[0];
      CouleurPerso = serialInArray[1]; //rouge
      xPerso = serialInArray[2]*3-50;
      yPerso = serialInArray[3]+100;
      sPerso = serialInArray[3]*2+100;
      
      // print the values (for debugging purposes only):
      println(ChoixPerso + "\t" + CouleurPerso + "\t" +  xPerso + "\t" + yPerso);
      
      // Send a capital A to request new sensor readings: Envoie d'une letter "A" pour signifier à la carte Arduino de renvoyer des données
      myPort.write('A');
      // Reset serialCount:
      serialCount = 0;
    }
  }
}
