/**
 * Create Image. 
 * 
 * The createImage() function provides a fresh buffer of pixels to play with.
 * This example creates an image gradient.
 */

PImage img, imgIntiale;
color c =color(#192A76);
int r = 25, g = 42, b=118;
// Arbre : 2480*2480
void setup() {
  size(1000, 570);
  background(255);
  imgIntiale = loadImage("Arbrecarre.png");
  img = createImage(imgIntiale.width, imgIntiale.width, ARGB);

  colorMode(HSB);

  //float a = map(i, 0, img.pixels.length, 255, 0);
  //img.pixels[i] = color(0, 153, 204, a);
}

void draw() {
  background(255);
  image(imgIntiale, 0, 0, 250, 250);

  for (int i = 0; i < imgIntiale.pixels.length; i++) {
    int r_i = (imgIntiale.pixels[i] >> 16) & 0xFF;  // Faster way of getting red(argb)
    int g_i = (imgIntiale.pixels[i] >> 8) & 0xFF;   // Faster way of getting green(argb)
    int b_i= imgIntiale.pixels[i] & 0xFF;          // Faster way of getting blue(argb)
    if (r_i == r && g_i == g && b_i == b) {
      float h = map(mouseX, 0, width, 0, 255);
      //float h = 128;
      float s = saturation(imgIntiale.pixels[i]);
      float b = brightness(imgIntiale.pixels[i]);

      //println("h =" + h + " s=" + s + " b=" +b);

      img.pixels[i] = color(h, s, b);
    }
    img.updatePixels();
  }


  image(img, 260, 260, 250, 250);
}
