int capteurs[] = {0, 0, 0, 0, 0}; // valeur des capteurs.5 capteurs. 0,1,2 : potentiomètres; 3,4 : boutons
byte bouton[] = {2, 3}; // pate des boutons
byte potPin[] = {0, 2, 5};
byte Ncapteurs = 5, Npotentiometres = 3, Nboutons = 2;
int inByte = 0;         // incoming serial byte
// mode debug
boolean debug = false; // mettre "false" pour envyer les données à Procssing

void setup() {

  // initialisation pattes boutons
  for (byte i = 0; i < Nboutons; i++) {
    pinMode(bouton[i], INPUT);
  }

  // start serial port at 9600 bps:
  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }
  // établir le contact avec Processing
  establishContact();  // send a byte to establish contact until receiver responds
}

void loop() {
  // if we get a valid byte, read analog ins:
  if (Serial.available() > 0) {
    // get incoming byte:
    inByte = Serial.read();
    if (inByte == 'A') {
      // read first analog input, divide by 4 to make the range 0-255:
      // lecture des donées siur les potars
      for (byte i = 0; i < Npotentiometres ; i++) { //Npotentiometre=3
        capteurs[i] = analogRead(potPin[i]) / 4;
        // delay 10ms to let the ADC recover:
        delay(10);
      }
      // lecture des données sur les boutons (à partir de capteur[3])
      // read switch, map it to 0 or 255
      for (byte i = 0; i < Nboutons; i++) {
        capteurs[i + 3]  = map(digitalRead(bouton[i]), 0, 1, 0, 255);
      }

      // send sensor values:
      if (debug) {
        Serial.println("val capteurs : ");
        for (byte i = 0; i < Npotentiometres + Nboutons; i++) {  //Npotentiometres + Nboutons = 5
          Serial.print(capteurs[i]);
          Serial.print("   ");
        }
        Serial.println("");
      }
      else { ///////////////////Envoie des octets bruts à PROCESING //////////////////////
        for (byte i = 0; i < Npotentiometres + Nboutons; i++) {  //Npotentiometres + Nboutons = 5
          Serial.write(capteurs[i]);
        }
      }
    }
  }
}

void establishContact() {
  while (Serial.available() <= 0) {
    Serial.print('A');   // send a capital A
    delay(300);
  }
}
