/**  Affiche tactile interactive - 
 *  Quand on appuie sur une touche (UP, DOWN, RIGHT, LEFT et espace ' '), cela lance une image, une vidéo, une annim, un son, etc...
 */
/// librairies
import processing.sound.*;
import processing.video.*; 
import processing.serial.*;


// bouton image active ? // est-ce que l'image est active ? Si oui, on affiche l'image
boolean animation_active = false; // true ou false (2 valleurs possibles) => 1 bit (0 ou 1)

// bouton son actif ?
boolean son_actif = false;
float tempsDebutSon = 0; // temps du début de la musique a été joué

// bouton video active ?
boolean video_active = false;

//potar teinte 
int potVal = 0;
int redVal = 0;


/// dialogue avec la carte Arduino
Serial myPort;  // Create object from Serial class
int  inBuffer;      // Data received from the serial port
int donneePortSerie; // entier converti de la chaine de caractère reçue sur le port série

// seuil de détection
float seuil = 300;

// port serie
int nCapteurs = 5;
int[] capteurs = new int[nCapteurs];    // données reçues via la carte Arduino
int serialCount = 0;                 // compteur de données reçues

boolean firstContact = false;        // Whether we've heard from the microcontroller
// média 
int nImages = 3;
String[] nomImages = new String[nImages];
PImage[] images = new PImage[nImages];
int nSon = 3;
String[] nomSon=new String[nSon];
SoundFile[] son; // un son - un seul lecteur CD audio
//Movie vid; // une vidéo - un seul lecteur DVD vidéo

// annim : glitch
PImage imageAffichee, imageInitiale;
int mode=0;
Glitch glitch;

// mode debug
boolean debug=true;


void setup() { // initialisation des paramètres d'affichage & chargement des sons, vidéos, etc.
  size(1000, 800);
  noStroke();
  background(0);
  colorMode(HSB);
  // initialisation des variables globales
  // capteurs
  for (int i=0; i<nCapteurs; i++) {
    capteurs[i]=0;
  }
  // nom son
  nomSon[0]= "sons/son2.mp3"; 
  //nomSon[1]= "sons/Armstrong.wav";
  //nomSon[2]= "sons/beat.aiff";
  // nom images
  nomImages[0]= "images/img1.jpg"; 
  nomImages[1]= "images/img2.jpg";
  nomImages[2]= "images/img3.jpg";
  // images
  for (int i=0; i<nImages; i++) {
    images[i]=loadImage(nomImages[i]);
  }
  // chargement des sons
  son =new SoundFile[nCapteurs];
  for (int i=0; i<nSon; i++) {
    son[i] = new SoundFile(this, nomSon[i]);
  }

  /// Port série
  // Print a list of the serial ports, for debugging purposes:
  printArray(Serial.list());

  String portName = Serial.list()[2];
  myPort = new Serial(this, portName, 9600);

  // intstanciation de la classe Glitch
  //glitch = new Glitch();
  //glitch = new Glitch("images/fond3.jpg");
  imageInitiale = loadImage("images/fond3.jpg");
  imageAffichee = imageInitiale.copy();
  glitch = new Glitch(imageAffichee);
}

void draw() {
  // chargement des pixels de l'image affichee
  imageAffichee.loadPixels();
  //loadPixels();
  //arrayCopy(pixels, imageAffichee.pixels);
  ///////////////////////// interactivités liées aux capteurs
  // potentiomètres : capteurs[0]-> capteurs[2]

  // potar 0: teinte
  tint(capteurs[0],255,255, capteurs[2]);


  // potar 1: glitch
  glitch.mode = floor(map(capteurs[1], 0, 255, 0, 2)); // sélection du mode de glitch : 0,1 2
  if (debug) {
    println("glitch.mode="+glitch.mode);
  }

  glitch.draw(imageAffichee);

  // potar 2: sound



  // interactivité liée aux boutons capteurs[3] et capteurs[4]
  if (capteurs[3]==255 && !son[0].isPlaying()) { // capteurs[3] ->son
    son[0].play();
  }

  if (capteurs[4]==255) { // capteurs[4] ->img
    for (int i=0; i<nImages; i++) {
      //float x = random(0, images[i].width);
      //float y = random(0, images[i].height);
      //image(images[i], x, y);
      float x = random(0, 400);
      float y = random(0, 400);
      image(images[i], x, y, 400, 400);

      // enregistrement de l'image dessinée dans imageAffichee


      
    }
    imageAffichee.updatePixels();
  }
}
