/*
 * Decompiled with CFR 0.152.
 */
package SimpleOpenNI;

import SimpleOpenNI.ContextWrapper;
import SimpleOpenNI.IntVector;
import SimpleOpenNI.SimpleOpenNIConstants;
import SimpleOpenNI.StrVector;
import SimpleOpenNI.Vec3f;
import java.lang.reflect.Method;
import java.net.URL;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PMatrix3D;
import processing.core.PVector;

public class SimpleOpenNI
extends ContextWrapper
implements SimpleOpenNIConstants {
    static String nativDepLibPath = "";
    static String nativLibPath = "";
    protected Object _userCbObject;
    protected Object _calibrationCbObject;
    protected Object _poseCbObject;
    protected Object _handCbObject;
    protected Object _gestureCbObject;
    protected Object _sessionCbObject;
    protected Method _newUserMethod;
    protected Method _lostUserMethod;
    protected Method _outOfSceneUserMethod;
    protected Method _visibleUserMethod;
    protected Method _newHandMethod;
    protected Method _trackedHandMethod;
    protected Method _lostHandMethod;
    protected Method _newGestureMethod;
    protected Method _inProgressGestureMethod;
    protected Method _abortedGestureMethod;
    protected Method _completedGestureMethod;
    protected Method _startSessionMethod;
    protected Method _endSessionMethod;
    protected Method _focusSessionMethod;
    protected String _filename;
    protected PApplet _parent;
    protected PImage _depthImage;
    protected int[] _depthRaw;
    protected PVector[] _depthMapRealWorld;
    protected float[] _depthMapRealWorldXn;
    protected PImage _rgbImage;
    protected PImage _irImage;
    protected PImage _sceneImage;
    protected int[] _sceneRaw;
    protected PImage _userImage;
    protected int[] _userRaw;
    protected long _depthMapTimeStamp;
    protected long _depthImageTimeStamp;
    protected long _depthRealWorldTimeStamp;
    protected long _rgbTimeStamp;
    protected long _irImageTimeStamp;
    protected long _userMapTimeStamp;
    protected long _userImageTimeStamp;
    protected float[] _tempVec = new float[3];
    protected static boolean _initFlag;

    public static String getLibraryPathLinux() {
        URL uRL = SimpleOpenNI.class.getResource("SimpleOpenNI.class");
        if (uRL != null) {
            String string = uRL.toString().replace("%20", " ");
            int n = string.indexOf(47);
            int n2 = -1;
            n2 = string.indexOf("/SimpleOpenNI/library");
            if (-1 < n && -1 < n2) {
                return string.substring(n, n2);
            }
            return "";
        }
        return "";
    }

    public static String getLibraryPathWin() {
        URL uRL = SimpleOpenNI.class.getResource("SimpleOpenNI.class");
        if (uRL != null) {
            String string = uRL.toString().replace("%20", " ");
            int n = string.indexOf(47);
            int n2 = -1;
            n2 = string.indexOf("/SimpleOpenNI/library");
            if (-1 < ++n && -1 < n2) {
                return string.substring(n, n2);
            }
            return "";
        }
        return "";
    }

    public static void start() {
        if (_initFlag) {
            return;
        }
        String string = SimpleOpenNI.getcwd();
        SimpleOpenNI.chdir(new String(nativDepLibPath));
        _initFlag = true;
        SimpleOpenNI.initContext();
        SimpleOpenNI.chdir(string);
    }

    public static int deviceCount() {
        SimpleOpenNI.start();
        return ContextWrapper.deviceCount();
    }

    public static int deviceNames(StrVector strVector) {
        SimpleOpenNI.start();
        return ContextWrapper.deviceNames(strVector);
    }

    public SimpleOpenNI(PApplet pApplet) {
        this.initEnv(pApplet, RUN_MODE_SINGLE_THREADED, -1);
    }

    public SimpleOpenNI(int n, PApplet pApplet) {
        this.initEnv(pApplet, RUN_MODE_SINGLE_THREADED, n);
    }

    public SimpleOpenNI(int n, PApplet pApplet, int n2) {
        this.initEnv(pApplet, n2, n);
    }

    public SimpleOpenNI(PApplet pApplet, int n) {
        this.initEnv(pApplet, n, -1);
    }

    public SimpleOpenNI(PApplet pApplet, String string, int n) {
        String string2 = pApplet.dataPath(string);
        String string3 = SimpleOpenNI.getcwd();
        SimpleOpenNI.chdir(new String(nativDepLibPath));
        this._parent = pApplet;
        pApplet.registerDispose((Object)this);
        this.initVars();
        this.setupCallbackFunc();
        this.init(string2, n);
        this.init(string2, RUN_MODE_DEFAULT);
        if ((this.nodes() & NODE_DEPTH) > 0) {
            this.setupDepth();
        }
        if ((this.nodes() & NODE_IMAGE) > 0) {
            this.setupRGB();
        }
        if ((this.nodes() & NODE_IR) > 0) {
            this.setupIR();
        }
        SimpleOpenNI.chdir(string3);
    }

    public SimpleOpenNI(PApplet pApplet, String string) {
        String string2 = pApplet.dataPath(string);
        String string3 = SimpleOpenNI.getcwd();
        SimpleOpenNI.chdir(new String(nativDepLibPath));
        this._parent = pApplet;
        pApplet.registerDispose((Object)this);
        this.initVars();
        this.setupCallbackFunc();
        this.init(string2, RUN_MODE_DEFAULT);
        if ((this.nodes() & NODE_DEPTH) > 0) {
            this.setupDepth();
        }
        if ((this.nodes() & NODE_IMAGE) > 0) {
            this.setupRGB();
        }
        if ((this.nodes() & NODE_IR) > 0) {
            this.setupIR();
        }
        SimpleOpenNI.chdir(string3);
    }

    protected void initEnv(PApplet pApplet, int n, int n2) {
        String string = SimpleOpenNI.getcwd();
        SimpleOpenNI.chdir(new String(nativDepLibPath));
        this._parent = pApplet;
        pApplet.registerDispose((Object)this);
        this.initVars();
        this.setupCallbackFunc();
        if (n2 < 0) {
            this.init(n);
        } else {
            this.init(n2, n);
        }
        SimpleOpenNI.chdir(string);
    }

    protected void initVars() {
        this._depthMapTimeStamp = -1L;
        this._depthImageTimeStamp = -1L;
        this._depthRealWorldTimeStamp = -1L;
        this._rgbTimeStamp = -1L;
        this._irImageTimeStamp = -1L;
        this._userMapTimeStamp = -1L;
        this._userImageTimeStamp = -1L;
    }

    protected void setupCallbackFunc() {
        this._userCbObject = this._parent;
        this._handCbObject = this._parent;
        this._gestureCbObject = this._parent;
        this._calibrationCbObject = this._parent;
        this._poseCbObject = this._parent;
        this._sessionCbObject = this._parent;
        this._newUserMethod = null;
        this._lostUserMethod = null;
        this._outOfSceneUserMethod = null;
        this._visibleUserMethod = null;
        this._newHandMethod = null;
        this._trackedHandMethod = null;
        this._lostHandMethod = null;
        this._newGestureMethod = null;
        this._inProgressGestureMethod = null;
        this._abortedGestureMethod = null;
        this._completedGestureMethod = null;
        this.setupUserCB(this._parent);
        this.setupHandCB(this._parent);
    }

    protected Method getMethodRef(String string, Class[] classArray) {
        Method method = null;
        try {
            method = this._parent.getClass().getMethod(string, classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public static Method getMethodRef(Object object, String string, Class[] classArray) {
        Method method = null;
        try {
            method = object.getClass().getMethod(string, classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public void dispose() {
        this.close();
    }

    @Override
    public void finalize() {
        this.close();
    }

    private void setupDepth() {
        this._depthImage = new PImage(this.depthWidth(), this.depthHeight(), 1);
        this._depthRaw = new int[this.depthMapSize()];
        this._depthMapRealWorld = new PVector[this.depthMapSize()];
        this._depthMapRealWorldXn = new float[this.depthMapSize() * 3];
        for (int i = 0; i < this.depthMapSize(); ++i) {
            this._depthMapRealWorld[i] = new PVector();
        }
    }

    @Override
    public boolean enableDepth() {
        if (super.enableDepth()) {
            this.setupDepth();
            return true;
        }
        return false;
    }

    public PImage depthImage() {
        this.updateDepthImage();
        return this._depthImage;
    }

    public int[] depthMap() {
        this.updateDepthRaw();
        return this._depthRaw;
    }

    public PVector[] depthMapRealWorld() {
        this.updateDepthRealWorld();
        return this._depthMapRealWorld;
    }

    private void setupRGB() {
        this._rgbImage = new PImage(this.rgbWidth(), this.rgbHeight(), 1);
    }

    @Override
    public boolean enableRGB() {
        if (super.enableRGB()) {
            this.setupRGB();
            return true;
        }
        return false;
    }

    @Override
    public boolean enableRGB(int n, int n2, int n3) {
        if (super.enableRGB(n, n2, n3)) {
            this.setupRGB();
            return true;
        }
        return false;
    }

    public PImage rgbImage() {
        this.updateImage();
        return this._rgbImage;
    }

    private void setupIR() {
        this._irImage = new PImage(this.irWidth(), this.irHeight(), 1);
    }

    @Override
    public boolean enableIR() {
        if (super.enableIR()) {
            this.setupIR();
            return true;
        }
        return false;
    }

    @Override
    public boolean enableIR(int n, int n2, int n3) {
        if (super.enableIR(n, n2, n3)) {
            this.setupIR();
            return true;
        }
        return false;
    }

    public PImage irImage() {
        this.updateIrImage();
        return this._irImage;
    }

    private void setupUserCB(Object object) {
        this._newUserMethod = SimpleOpenNI.getMethodRef(object, "onNewUser", new Class[]{SimpleOpenNI.class, Integer.TYPE});
        this._lostUserMethod = SimpleOpenNI.getMethodRef(object, "onLostUser", new Class[]{SimpleOpenNI.class, Integer.TYPE});
        this._outOfSceneUserMethod = SimpleOpenNI.getMethodRef(object, "onOutOfSceneUser", new Class[]{SimpleOpenNI.class, Integer.TYPE});
        this._visibleUserMethod = SimpleOpenNI.getMethodRef(object, "onVisibleUser", new Class[]{SimpleOpenNI.class, Integer.TYPE});
    }

    private void setupUser() {
        this._userRaw = new int[this.userWidth() * this.userHeight()];
        this._userImage = new PImage(this.userWidth(), this.userHeight(), 1);
    }

    @Override
    public boolean enableUser() {
        return this.enableUser(this._parent);
    }

    public boolean enableUser(Object object) {
        String string = SimpleOpenNI.getcwd();
        SimpleOpenNI.chdir(new String(nativDepLibPath));
        boolean bl = super.enableUser();
        SimpleOpenNI.chdir(string);
        if (bl) {
            this.setupUserCB(object);
            this.setupUser();
            return true;
        }
        return false;
    }

    public PImage userImage() {
        this.updateUserImage();
        return this._userImage;
    }

    public int[] userMap() {
        this.updateUserRaw();
        return this._userRaw;
    }

    public boolean getCoM(int n, PVector pVector) {
        float[] fArray = new float[3];
        boolean bl = super.getCoM(n, fArray);
        pVector.set(fArray);
        return bl;
    }

    public boolean getBoundingBox(int n, PVector pVector, PVector pVector2) {
        float[] fArray = new float[6];
        boolean bl = super.getBoundingBox(n, fArray);
        pVector.set(fArray[0], fArray[1], fArray[2]);
        pVector2.set(fArray[3], fArray[4], fArray[5]);
        return bl;
    }

    public int[] getUsers() {
        IntVector intVector = new IntVector();
        this.getUsers(intVector);
        int[] nArray = new int[(int)intVector.size()];
        int n = 0;
        while ((long)n < intVector.size()) {
            nArray[n] = intVector.get(n);
            ++n;
        }
        return nArray;
    }

    private void setupHandCB(Object object) {
        this._newHandMethod = SimpleOpenNI.getMethodRef(object, "onNewHand", new Class[]{SimpleOpenNI.class, Integer.TYPE, PVector.class});
        this._trackedHandMethod = SimpleOpenNI.getMethodRef(object, "onTrackedHand", new Class[]{SimpleOpenNI.class, Integer.TYPE, PVector.class});
        this._lostHandMethod = SimpleOpenNI.getMethodRef(object, "onLostHand", new Class[]{SimpleOpenNI.class, Integer.TYPE});
        this._newGestureMethod = SimpleOpenNI.getMethodRef(object, "onNewGesture", new Class[]{SimpleOpenNI.class, Integer.TYPE});
        this._inProgressGestureMethod = SimpleOpenNI.getMethodRef(object, "onProgressGesture", new Class[]{SimpleOpenNI.class, Integer.TYPE});
        this._abortedGestureMethod = SimpleOpenNI.getMethodRef(object, "onAbortedGesture", new Class[]{SimpleOpenNI.class, Integer.TYPE});
        this._completedGestureMethod = SimpleOpenNI.getMethodRef(object, "onCompletedGesture", new Class[]{SimpleOpenNI.class, Integer.TYPE, PVector.class});
    }

    @Override
    public boolean enableHand() {
        return this.enableHand(this._parent);
    }

    public boolean enableHand(Object object) {
        this._handCbObject = object;
        if (super.enableHand()) {
            this.setupHandCB(this._handCbObject);
            return true;
        }
        return false;
    }

    public int startTrackingHand(PVector pVector) {
        return super.startTrackingHand(pVector.array());
    }

    @Override
    public boolean enableRecorder(String string) {
        String string2 = this._parent.dataPath(string);
        PApplet.createPath((String)string2);
        return super.enableRecorder(string2);
    }

    protected void updateDepthRaw() {
        if ((this.nodes() & NODE_DEPTH) == 0) {
            return;
        }
        if (this._depthMapTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this.depthMap(this._depthRaw);
        this._depthMapTimeStamp = this.updateTimeStamp();
    }

    protected void updateDepthImage() {
        if ((this.nodes() & NODE_DEPTH) == 0) {
            return;
        }
        if (this._depthImageTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this._depthImage.loadPixels();
        this.depthImage(this._depthImage.pixels);
        this._depthImage.updatePixels();
        this._depthImageTimeStamp = this.updateTimeStamp();
    }

    protected void updateDepthRealWorld() {
        if ((this.nodes() & NODE_DEPTH) == 0) {
            return;
        }
        if (this._depthRealWorldTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this.depthMapRealWorld(this._depthMapRealWorldXn);
        int n = 0;
        for (int i = 0; i < this._depthMapRealWorld.length; ++i) {
            this._depthMapRealWorld[i].set(this._depthMapRealWorldXn[n++], this._depthMapRealWorldXn[n++], this._depthMapRealWorldXn[n++]);
        }
        this._depthRealWorldTimeStamp = this.updateTimeStamp();
    }

    protected void updateImage() {
        if ((this.nodes() & NODE_IMAGE) == 0) {
            return;
        }
        if (this._rgbTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this._rgbImage.loadPixels();
        this.rgbImage(this._rgbImage.pixels);
        this._rgbImage.updatePixels();
        this._rgbTimeStamp = this.updateTimeStamp();
    }

    protected void updateIrImage() {
        if ((this.nodes() & NODE_IR) == 0) {
            return;
        }
        if (this._irImageTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this._irImage.loadPixels();
        this.irImage(this._irImage.pixels);
        this._irImage.updatePixels();
        this._irImageTimeStamp = this.updateTimeStamp();
    }

    protected void updateUserRaw() {
        if ((this.nodes() & NODE_USER) == 0) {
            return;
        }
        if (this._userImageTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this.userMap(this._userRaw);
        this._userImageTimeStamp = this.updateTimeStamp();
    }

    protected void updateUserImage() {
        if ((this.nodes() & NODE_USER) == 0) {
            return;
        }
        if (this._userImageTimeStamp == this.updateTimeStamp()) {
            return;
        }
        this._userImage.loadPixels();
        this.userImage(this._userImage.pixels);
        this._userImage.updatePixels();
        this._userImageTimeStamp = this.updateTimeStamp();
    }

    @Override
    public void update() {
        super.update();
    }

    public void drawLimb(int n, int n2, int n3) {
        PVector pVector = new PVector();
        PVector pVector2 = new PVector();
        this.getJointPositionSkeleton(n, n2, pVector);
        this.getJointPositionSkeleton(n, n3, pVector2);
        PVector pVector3 = new PVector();
        PVector pVector4 = new PVector();
        this.convertRealWorldToProjective(pVector, pVector3);
        this.convertRealWorldToProjective(pVector2, pVector4);
        this._parent.line(pVector3.x, pVector3.y, pVector4.x, pVector4.y);
    }

    public float getJointPositionSkeleton(int n, int n2, PVector pVector) {
        float f = this.getJointPositionSkeleton(n, n2, this._tempVec);
        pVector.set(this._tempVec);
        return f;
    }

    public float getJointOrientationSkeleton(int n, int n2, PMatrix3D pMatrix3D) {
        float[] fArray = new float[9];
        float f = this.getJointOrientationSkeleton(n, n2, fArray);
        pMatrix3D.set(fArray[0], fArray[1], fArray[2], 0.0f, fArray[3], fArray[4], fArray[5], 0.0f, fArray[6], fArray[7], fArray[8], 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        return f;
    }

    public void convertRealWorldToProjective(PVector pVector, PVector pVector2) {
        this.convertRealWorldToProjective(pVector.array(), this._tempVec);
        pVector2.set(this._tempVec);
    }

    public void convertProjectiveToRealWorld(PVector pVector, PVector pVector2) {
        this.convertProjectiveToRealWorld(pVector.array(), this._tempVec);
        pVector2.set(this._tempVec);
    }

    public void getUserCoordsysTransMat(PMatrix3D pMatrix3D) {
        if (!this.hasUserCoordsys()) {
            return;
        }
        float[] fArray = new float[16];
        this.getUserCoordsysTransMat(fArray);
        pMatrix3D.set(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7], fArray[8], fArray[9], fArray[10], fArray[11], fArray[12], fArray[13], fArray[14], fArray[15]);
    }

    public void calcUserCoordsys(PVector pVector) {
        if (!this.hasUserCoordsys()) {
            return;
        }
        float[] fArray = new float[3];
        this.calcUserCoordsys(fArray);
        pVector.set(fArray[0], fArray[1], fArray[2]);
    }

    public void calcUserCoordsys(PMatrix3D pMatrix3D) {
        if (!this.hasUserCoordsys()) {
            return;
        }
        float[] fArray = new float[]{pMatrix3D.m00, pMatrix3D.m01, pMatrix3D.m02, pMatrix3D.m10, pMatrix3D.m11, pMatrix3D.m12, pMatrix3D.m20, pMatrix3D.m21, pMatrix3D.m22};
        this.calcUserCoordsys(fArray);
        pMatrix3D.set(fArray[0], fArray[1], fArray[2], 0.0f, fArray[3], fArray[4], fArray[5], 0.0f, fArray[6], fArray[7], fArray[8], 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void calcUserCoordsysBack(PVector pVector) {
        if (!this.hasUserCoordsys()) {
            return;
        }
        float[] fArray = new float[3];
        this.calcUserCoordsysBack(fArray);
        pVector.set(fArray[0], fArray[1], fArray[2]);
    }

    public void calcUserCoordsysBack(PMatrix3D pMatrix3D) {
        if (!this.hasUserCoordsys()) {
            return;
        }
        float[] fArray = new float[]{pMatrix3D.m00, pMatrix3D.m01, pMatrix3D.m02, pMatrix3D.m10, pMatrix3D.m11, pMatrix3D.m12, pMatrix3D.m20, pMatrix3D.m21, pMatrix3D.m22};
        this.calcUserCoordsysBack(fArray);
        pMatrix3D.set(fArray[0], fArray[1], fArray[2], 0.0f, fArray[3], fArray[4], fArray[5], 0.0f, fArray[6], fArray[7], fArray[8], 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void getUserCoordsys(PMatrix3D pMatrix3D) {
        if (!this.hasUserCoordsys()) {
            return;
        }
        float[] fArray = new float[16];
        this.getUserCoordsys(fArray);
        pMatrix3D.set(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7], fArray[8], fArray[9], fArray[10], fArray[11], fArray[12], fArray[13], fArray[14], fArray[15]);
    }

    public void getUserCoordsysBack(PMatrix3D pMatrix3D) {
        if (!this.hasUserCoordsys()) {
            return;
        }
        float[] fArray = new float[16];
        this.getUserCoordsysBack(fArray);
        pMatrix3D.set(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7], fArray[8], fArray[9], fArray[10], fArray[11], fArray[12], fArray[13], fArray[14], fArray[15]);
    }

    public void drawCamFrustum() {
        this._parent.g.pushStyle();
        this._parent.g.pushMatrix();
        if (this.hasUserCoordsys()) {
            PMatrix3D pMatrix3D = new PMatrix3D();
            this.getUserCoordsys(pMatrix3D);
            this._parent.g.applyMatrix(pMatrix3D);
        }
        this._parent.stroke(200.0f, 200.0f, 0.0f);
        this._parent.noFill();
        this._parent.g.beginShape();
        this._parent.g.vertex(135.0f, 20.0f, 0.0f);
        this._parent.g.vertex(-135.0f, 20.0f, 0.0f);
        this._parent.g.vertex(-135.0f, -20.0f, 0.0f);
        this._parent.g.vertex(135.0f, -20.0f, 0.0f);
        this._parent.g.endShape(2);
        this._parent.g.beginShape();
        this._parent.g.vertex(110.0f, 20.0f, -50.0f);
        this._parent.g.vertex(-110.0f, 20.0f, -50.0f);
        this._parent.g.vertex(-110.0f, -20.0f, -50.0f);
        this._parent.g.vertex(110.0f, -20.0f, -50.0f);
        this._parent.g.endShape(2);
        this._parent.g.beginShape(5);
        this._parent.g.vertex(135.0f, 20.0f, 0.0f);
        this._parent.g.vertex(110.0f, 20.0f, -50.0f);
        this._parent.g.vertex(-135.0f, 20.0f, 0.0f);
        this._parent.g.vertex(-110.0f, 20.0f, -50.0f);
        this._parent.g.vertex(-135.0f, -20.0f, 0.0f);
        this._parent.g.vertex(-110.0f, -20.0f, -50.0f);
        this._parent.g.vertex(135.0f, -20.0f, 0.0f);
        this._parent.g.vertex(110.0f, -20.0f, -50.0f);
        this._parent.g.endShape();
        this._parent.stroke(200.0f, 200.0f, 0.0f, 50.0f);
        this._parent.g.line(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1000.0f);
        float f = 10000.0f;
        float f2 = f * PApplet.tan((float)(this.hFieldOfView() * 0.5f));
        float f3 = f * PApplet.tan((float)(this.vFieldOfView() * 0.5f));
        this._parent.stroke(200.0f, 200.0f, 0.0f, 100.0f);
        this._parent.g.line(0.0f, 0.0f, 0.0f, f2, f3, f);
        this._parent.g.line(0.0f, 0.0f, 0.0f, -f2, f3, f);
        this._parent.g.line(0.0f, 0.0f, 0.0f, f2, -f3, f);
        this._parent.g.line(0.0f, 0.0f, 0.0f, -f2, -f3, f);
        this._parent.g.beginShape();
        this._parent.g.vertex(f2, f3, f);
        this._parent.g.vertex(-f2, f3, f);
        this._parent.g.vertex(-f2, -f3, f);
        this._parent.g.vertex(f2, -f3, f);
        this._parent.g.endShape(2);
        this._parent.g.popMatrix();
        this._parent.g.popStyle();
    }

    public static boolean rayTriangleIntersection(PVector pVector, PVector pVector2, PVector pVector3, PVector pVector4, PVector pVector5, PVector pVector6) {
        float[] fArray = new float[3];
        if (SimpleOpenNI.rayTriangleIntersection(pVector.array(), pVector2.array(), pVector3.array(), pVector4.array(), pVector5.array(), fArray)) {
            pVector6.set(fArray);
            return true;
        }
        return false;
    }

    public static int raySphereIntersection(PVector pVector, PVector pVector2, PVector pVector3, float f, PVector pVector4, PVector pVector5) {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n = SimpleOpenNI.raySphereIntersection(pVector.array(), pVector2.array(), pVector3.array(), f, fArray, fArray2);
        if (n > 0) {
            pVector4.set(fArray);
            if (n > 1) {
                pVector5.set(fArray2);
            }
        }
        return n;
    }

    @Override
    protected void onNewUserCb(int n) {
        try {
            this._newUserMethod.invoke(this._userCbObject, this, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onLostUserCb(int n) {
        try {
            this._lostUserMethod.invoke(this._userCbObject, this, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onOutOfSceneUserCb(int n) {
        try {
            this._outOfSceneUserMethod.invoke(this._userCbObject, this, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onVisibleUserCb(int n) {
        try {
            this._visibleUserMethod.invoke(this._userCbObject, this, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onNewHandCb(int n, Vec3f vec3f) {
        try {
            this._newHandMethod.invoke(this._handCbObject, this, n, new PVector(vec3f.x(), vec3f.y(), vec3f.z()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onLostHandCb(int n) {
        try {
            this._lostHandMethod.invoke(this._handCbObject, this, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onTrackedHandCb(int n, Vec3f vec3f) {
        try {
            this._trackedHandMethod.invoke(this._handCbObject, this, n, new PVector(vec3f.x(), vec3f.y(), vec3f.z()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onNewGestureCb(int n) {
        try {
            this._newGestureMethod.invoke(this._handCbObject, this, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onInProgressGestureCb(int n) {
        try {
            this._inProgressGestureMethod.invoke(this._handCbObject, this, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onAbortedGestureCb(int n) {
        System.out.println("onAbortedGestureCb");
        try {
            this._abortedGestureMethod.invoke(this._handCbObject, this, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void onCompletedGestureCb(int n, Vec3f vec3f) {
        try {
            this._completedGestureMethod.invoke(this._handCbObject, this, n, new PVector(vec3f.x(), vec3f.y(), vec3f.z()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = "SimpleOpenNI";
        String string3 = System.getProperty("os.arch").toLowerCase();
        if (string.indexOf("win") >= 0) {
            if (string3.indexOf("86") >= 0) {
                string2 = string2 + "32.dll";
                nativLibPath = SimpleOpenNI.getLibraryPathWin() + "/SimpleOpenNI/library/";
                nativDepLibPath = nativLibPath + "win32/";
            } else if (string3.indexOf("64") >= 0) {
                string2 = string2 + "64.dll";
                nativLibPath = SimpleOpenNI.getLibraryPathWin() + "/SimpleOpenNI/library/";
                nativDepLibPath = nativLibPath + "win64/";
            }
            System.load(nativDepLibPath + "OpenNI2.dll");
            System.load(nativDepLibPath + "NiTE2.dll");
        } else if (string.indexOf("nix") >= 0 || string.indexOf("linux") >= 0) {
            nativLibPath = "/SimpleOpenNI/library/linux";
            if (string3.indexOf("86") >= 0) {
                string2 = string2 + "32";
            } else if (string3.indexOf("64") >= 0) {
                string2 = "lib" + string2 + "64.so";
                nativLibPath = SimpleOpenNI.getLibraryPathLinux() + "/SimpleOpenNI/library/";
                nativDepLibPath = nativLibPath + "linux64/";
            }
        } else if (string.indexOf("mac") >= 0) {
            string2 = "lib" + string2 + ".jnilib";
            nativLibPath = SimpleOpenNI.getLibraryPathLinux() + "/SimpleOpenNI/library/";
            nativDepLibPath = nativLibPath + "osx/";
        }
        try {
            System.load(nativLibPath + string2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("Can't load SimpleOpenNI library (" + string2 + ") : " + unsatisfiedLinkError);
            System.out.println("Verify if you installed SimpleOpenNI correctly.\nhttp://code.google.com/p/simple-openni/wiki/Installation");
        }
        _initFlag = false;
    }
}

