//snake 

class Snake {
  // x and y positions
  int[] xpos;
  int[] ypos;

  // The constructor determines the length of the snake
  Snake(int n) {
    xpos = new int[n];
    ypos = new int[n];
  }

  void update(int newX, int newY) {
    // Shift all elements down one spot. 
    // xpos[0] = xpos[1], xpos[1] = xpos = [2], and so on. Stop at the second to last element.
    for (int i = 0; i < xpos.length-1; i ++ ) {
      xpos[i] = xpos[i+1]; 
      ypos[i] = ypos[i+1];
    }

    // Update the last spot in the array with the mouse location.
    xpos[xpos.length-1] = newX; 
    ypos[ypos.length-1] = newY;
  }

  void display() {
    // Draw everything
    for (int i = 0; i < xpos.length; i ++ ) {
     //for (int i = 0; i < nbPts; i ++ ) {
      // Draw an ellipse for each element in the arrays. 
      // Color and size are tied to the loop's counter: i.
      noStroke();
      fill(255);
      //tracé des points détectés
      ellipse(xpos[i],ypos[i],20,20); 
      
      // tracé des lignes joignant les points tracés
      if (i>0){
        line(xpos[i-1],ypos[i-1], xpos[i],ypos[i]);
      }
    }
  }
  
  void display(int nbPts) {
    // Draw everything
   //for (int i = 0; i < xpos.length; i ++ ) {
    for (int i = 0; i < nbPts; i ++ ) {
      // Draw an ellipse for each element in the arrays. 
      // Color and size are tied to the loop's counter: i.
      noStroke();
      fill(255);
      //tracé des points détectés
      ellipse(xpos[i],ypos[i],20,20); 
      
      // tracé des lignes joignant les points tracés
      if (i>0){
        line(xpos[i-1],ypos[i-1], xpos[i],ypos[i]);
      }
    }
  }
  
  void displayCurve(int nbPts) {
    // Draw everything
   // for (int i = 0; i < xpos.length; i ++ ) {
     for (int i = 0; i < nbPts; i ++ ) {
      // Draw an ellipse for each element in the arrays. 
      // Color and size are tied to the loop's counter: i.
      noStroke();
      fill(255);
      //tracé des points détectés
      ellipse(xpos[i],ypos[i],20,20); 
     }
      
      // tracé de la courbe joignant les points tracés
      noFill();
      stroke(0);
      beginShape();
        curveVertex(xpos[0],ypos[0]); // 1er point de contrôle
        for (int i = 0; i < nbPts; i ++ ) {
          curveVertex(xpos[i],ypos[i]); // 1er point de contrôle
          
        }
        curveVertex(xpos[nbPts-1],ypos[nbPts-1]); // dernier point de contrôle
      endShape();
   
  }
  

}