/*
 * Decompiled with CFR 0.152.
 */
package milchreis.imageprocessing;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import milchreis.imageprocessing.Cube;
import milchreis.imageprocessing.utils.Tools;
import processing.core.PImage;

public class CubeLUT {
    public static Cube parse(File file) {
        Cube cube = new Cube();
        try {
            List<String> list = Files.readAllLines(file.toPath());
            for (String string : list) {
                if ((string = string.trim()).startsWith("#") || string.isEmpty()) continue;
                String[] stringArray = string.split("\\s+");
                if (stringArray[0].equals("TITLE")) {
                    cube.title = stringArray[0];
                    continue;
                }
                if (stringArray[0].equals("DOMAIN_MIN")) {
                    cube.domainMin = new float[]{Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3])};
                    continue;
                }
                if (stringArray[0].equals("DOMAIN_MAX")) {
                    cube.domainMax = new float[]{Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3])};
                    continue;
                }
                if (stringArray[0].equals("LUT_1D_SIZE")) {
                    cube.type = "1D";
                    cube.size = Integer.parseInt(stringArray[1]);
                    continue;
                }
                if (stringArray[0].equals("LUT_3D_SIZE")) {
                    cube.type = "3D";
                    cube.size = Integer.parseInt(stringArray[1]);
                    continue;
                }
                cube.rgb.add(Float.valueOf(Float.parseFloat(stringArray[0])));
                cube.rgb.add(Float.valueOf(Float.parseFloat(stringArray[1])));
                cube.rgb.add(Float.valueOf(Float.parseFloat(stringArray[2])));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return cube;
    }

    public static PImage apply(PImage pImage, Cube cube) {
        PImage pImage2 = Tools.createBlankImageLike(pImage);
        for (int i = 0; i < pImage.height; ++i) {
            for (int j = 0; j < pImage.width; ++j) {
                int[] nArray = Tools.getColors(pImage, j, i);
                float f = (float)nArray[0] / 255.0f;
                float f2 = (float)nArray[1] / 255.0f;
                float f3 = (float)nArray[2] / 255.0f;
                f = (f - cube.domainMin[0]) / (cube.domainMax[0] - cube.domainMin[0]);
                f2 = (f2 - cube.domainMin[1]) / (cube.domainMax[1] - cube.domainMin[1]);
                f3 = (f3 - cube.domainMin[2]) / (cube.domainMax[2] - cube.domainMin[2]);
                f *= (float)(cube.size - 1);
                f2 *= (float)(cube.size - 1);
                float f4 = f < 0.0f ? 0.0f : (f = f > (float)(cube.size - 1) ? (float)(cube.size - 1) : f);
                float f5 = f2 < 0.0f ? 0.0f : (f2 = f2 > (float)(cube.size - 1) ? (float)(cube.size - 1) : f2);
                f3 = f3 < 0.0f ? 0.0f : (f3 > (float)(cube.size - 1) ? (float)(cube.size - 1) : (f3 *= (float)(cube.size - 1)));
            }
        }
        return pImage2;
    }
}

