/**
  NyARToolkit for proce55ing/1.0.0
  (c)2008-2011 nyatla
  airmail(at)ebony.plala.or.jp
  
  This sample proglam handles 2 ARToolKit marker.
  The markers are "patt.hiro" and "patt.kanji"
  2 differents 3D .obj models textured
*/

// 4 marqueurs (CMYK) + 4 .obj 

// appeler les Librairies
import processing.video.*;
import jp.nyatla.nyar4psg.*;
import saito.objloader.*;

// Variables camera + nyar 
Capture cam;
MultiMarker nya;

// déclaration objet 3D
OBJModel cyan;
OBJModel magenta;
OBJModel jaune;
OBJModel noir;

// Gestion du rendu, texture, maillage
// variables de type booléenne true/false
boolean bTexture = true;
boolean bStroke = false;
boolean bMaterial = true;

// int Width Height
int arWidth = 640;
int arHeight = 480;

//appelle du début de la programmation, initiation des paramètres
void setup() {
  //taille de la fenêtre de l'écran ordinateur , l'OPENGL appelle la 3D
  size(1280,720,OPENGL);
// mode de couleur
  colorMode(RGB, 100);
  //pas d'affichage du curseur  
  noCursor();
  //afficher, pour vérification de la fonction Multimarker
  println(MultiMarker.VERSION);  
  
//création (appelle) de la webcam
  cam=new Capture(this,1280,720);//taille de la caméra
  //création (appelle) de la fonction Multimarker (reconnaissance des marqueurs)  la taille de l'apparition des marqueurs à l'écran 
  nya=new MultiMarker(this,width,height,"camera_para.dat",NyAR4PsgConfig.CONFIG_PSG);
  //appelle de chaques marqueurs
  nya.addARMarker("data/patt.cyan",80);//id=0 importation du marqueur1 
  nya.addARMarker("data/patt.magenta",80);//id=1 importation du marqueur 2 
  nya.addARMarker("data/patt.yellow",80);//id=2 importation du marqueur 3 
  nya.addARMarker("data/patt.black",80);//id=3 importation du marqueur 4
  

// importation du modèle cyan et association au marqueur correspondant (Delphine)
  cyan = new OBJModel(this, "data/cyan.obj", "absolute", TRIANGLES);
  cyan.enableDebug(); //enableDebug a trouver des precision sur le site de Processing
// taille du modèle
  cyan.scale(8);

// importation du modèle magenta (Marine)
  magenta = new OBJModel(this, "data/magenta.obj", "absolute", TRIANGLES);
  magenta.enableDebug();
// taille du modèle
  magenta.scale(20);

// importation du modèle jaune (Chloé)
  jaune = new OBJModel(this, "data/jaune.obj", "absolute", TRIANGLES);
  jaune.enableDebug();
// taille du modèle
  jaune.scale(18);
 
// importation du modèle noir (Selma)
  noir = new OBJModel(this, "data/noir.obj", "absolute", TRIANGLES);
  magenta.enableDebug();
// taille du modèle
  noir.scale(20);
 
// démarrage caméra 
  cam.start();
 
}

// rafraichissement en boucle 
void draw()
{
  //Boucle vérification de l'activation de la caméra
  if (cam.available() !=true) {
      return;
  }
  //ajout de lumière
  directionalLight(255,255,255,0,-1,-1);
  // création du lien entre la webcam et la librairie nya
  cam.read();
  nya.detect(cam);
  background(0);
  //détermination de ce qui apparaitra à 'écran
  image(cam, 0, 0, width,height);
  
  nya.drawBackground(cam);
  PImage cSmall = cam.get();
  cSmall.resize(arWidth, arHeight);
    //boucle for 
  for(int i=0;i<1;i++){
    if((!nya.isExistMarker(0))){
      continue;
    }
    nya.beginTransform(i);
    //pas de contour
    noStroke();
    // translate l'île cyan de 5 cm vers le haut dans l'apparition écran
    translate(0,0,5); 
    cyan.draw();
    nya.endTransform();
  }
  //condition boucle
   for(int i=1;i<2;i++){
    if((!nya.isExistMarker(1))){
      continue;
    }
    nya.beginTransform(i);
    //pas de contour
    noStroke();
    // translate l'île magenta de 10 cm vers le haut dans l'apparition écran
    translate(0,0,10);
    // rotation 
    rotateX(-PI/2);
    magenta.draw();
    nya.endTransform();
  }
  for(int i=2;i<3;i++){
    if((!nya.isExistMarker(2))){
      continue;
    }
     nya.beginTransform(i);
     //pas de contour
    noStroke();
    // translate l'île jaune de 10 cm vers le haut dans l'apparition écran
    translate(0,0,10);
    jaune.draw();
    nya.endTransform();
  }
  for(int i=3;i<4;i++){
    if((!nya.isExistMarker(3))){
      continue;
    }
     nya.beginTransform(i);
     //pas de contour
    noStroke();
    // translate l'île noir de 20 cm vers le haut dans l'apparition écran
    translate(0,0,20);
    noir.draw();
    nya.endTransform();
  }
  
}