
//---------------initialisation des paramètres pour tout le code---------------//
//constructor : c'est lui qui va créer l'objet
ArrayList<Particle> pts; //Tableau dynamique d'objet qui est lui même un objet (objet qui va contenir des objets)
boolean onPressed, showInstruction; //page d'accueil qui fonction en langage boolean (0,1) par le clique ou pas de la souris 
PFont f; //pour appeler la police on le nomme "f"

//---------------initialisation des paramètres d'affichages---------------//

void setup() {          
  size(720, 720, P2D);               // taille (hauteur, largeur)de la fenêtre avec un plan en 2D
  smooth();                          //
  frameRate(30);                     //
  colorMode(RGB);                    // Mode colorimétrique du projet RGB   
  pts = new ArrayList<Particle>();   // le point prend la valeur de particule
  
  showInstruction = true;             //afficher la page d'accueil (le titre)
  f = createFont("arial", 40, true);// la typographie désigné "f" aura pour police "arial" de taille 40
  
  background(0);                    // fond noir
}

//---------------fin des paramètres d'affichages---------------//




//---------------Paramètres dessin---------------//

void draw() {
   //--------Paramètre page de garde : titre---------
   if (showInstruction) {                        //si la page d'accueil est ouverte alors :
    background(0);                               //fond d'écran noir
    fill(255);                                   //couleur du texte blanc
    textAlign(CENTER, CENTER);                   //alignement : centré (milieu de la longueur et milieu de la hauteur)
    textFont(f);                                 //police nommé f reprend les paramètres du setup 
    textLeading(60);                             //espacement des mots à 60
    text("Il n'y a pas de hasard." + "\n" +      //texte inscrit ("\n") = à la ligne
      "le HASARD c'est vous !" + "\n"
      , width*0.5, height*0.5);                  //largeur et hauteur du caractère
  }
  
  
  //----- Fin des paramètres : page de garde : titre---------

  if (onPressed) {                          //si la fonction onpressed est activée
    for (int i=0; i<10; i++) {              // Boucle : créer "particule" tant que il n'y en n'a pas 11 (contôle le nombre de répartition = branches du dessin-
      Particle newP = new Particle(mouseX, mouseY, i+pts.size(), i+pts.size()); //création de "particule"(nouvelle classe/objet) déterminée par la position du pointeur de la souris et la taille 
      pts.add(newP);                        //ajoute méthode .add à une nouvelle particule
    }
  }

  for (int i=0; i<pts.size(); i++) { // boucle : Mettre à jours le dessin par rapport à la position, leurs tailles des particules
    Particle p = pts.get(i);         // méthode".get"
    p.update();                      //rafraichissement
    p.display();                     //
  } 

  for (int i=pts.size()-1; i>-1; i--) { // boucle : Réduction de particule décompte ils deviennent de plus en plus petit
    Particle p = pts.get(i);            
    if (p.dead) {                       //s'arrête de bouger /si particule est mort/nulle =0 particule s'arrête de fonctionner
      pts.remove(i);           //méthode .remove
    }
  }
}
//---------------Fin des paramètres dessin---------------//



//---------------paramètres clique (souris)---------------//
void mousePressed() {           //Quand on clique
  onPressed = true;             //La fonction "onPressed" (le dessin) s'active 
  if (showInstruction) {        // si les instructions sont ouvertes alors :
    background(0);              // le fond devient noir
    showInstruction = false;    // et la page d'accueil s'arrête s'enlève
}
}


//---------------paramètres clique relâché (souris)---------------//
void mouseReleased() {         //Quand on relâche le clique    
  onPressed = false;           //La fonction(le dessin) continue de s'exécuter mais s'arrêtera une fois terminée
}



//---------------paramètres touche de clavier---------------//
void keyPressed() {                        //quand on appuie sur une touche
  if (key == 'c') {                        //si la touche "c" est enfoncée
    for (int i=pts.size()-1; i>-1; i--) { //alors on supprime toutes les particules
      Particle p = pts.get(i);
      pts.remove(i);
    }
    background(0);                      // + on rajoute un fond noir par-dessus
  }
}




class Particle {                      //fonction qui s'exécute en deuxième plan class / on créer quelque chose de physique
  PVector loc, vel, acc;             // création d'un vecteur (localisation du point de départ, direction , la longeur)
  int lifeSpan, passedLife;          // variable de la fonction
  boolean dead;                      // variable de la fonction (boolean 0 ou 1)
  float alpha, weight, weightRange, decay, xOffset, yOffset;    // variable de la fonction
  color c;                           // variable de la fonction

  //---------------création d'une particule/d'un cercle---------------//
  
  Particle(float x, float y, float xOffset, float yOffset) {   // définition de la fonction : new Particle(mouseX, mouseY, i+pts.size(), i+pts.size())  
    loc = new PVector(x, y);                                   // création d'un vecteur de position x et y

    float randDegrees = random(360);                           // randDegrees : prend la valeur d'un nombre aléatoire d'un nombre de 0 et 360
    vel = new PVector(cos(radians(randDegrees)), sin(radians(randDegrees))); // prend la valeur/d'une direction aléatoire a 360° 
    //vel.mult(random(1));                                     // multiplier "vel" par 5

    acc = new PVector(0, 0);                 //la longueur prend la valeur du nouveau PVecteur (0,0)
    lifeSpan = int(random(30, 400));         // la durée de vie de particule au bout de temps(random) de création
    decay = random(400, 0);                  // espacements des particules (serré ou pas serré)
    c = color(random(0), random(255), 255);  // c prend la couleur R = valeur aléatoire (entre 0 et 0) , G= valeur aléatoire (entre 0 et 255), B = valeur à 255 , 
    weightRange = random(3, 60);             //coefficient aléatoire pour la grosseur du cercle

    this.xOffset = xOffset;
    this.yOffset = yOffset;
  }

  //mise à jour : temps que la particule n'a pas atteint le nombre "lifeSpan" de vie alors elle continue de vivre
  void update() {
    if (passedLife>=lifeSpan) {
      dead = true;
    } else {
      passedLife++;                // on lui rajoute une vie +1
    }
    
//----------------------calcule pour la création d'une nouvelle particule-----------------------------

    alpha = float(lifeSpan-passedLife)/lifeSpan * 30;           // formule pour : diminuer la transparence/l'opacité de plus en plus
    weight = float(lifeSpan-passedLife)/lifeSpan * weightRange; // formule pour : diminur de plus en plus la taille 

    acc.set(0, 0);        // la longueur prend la valeur 0,0

    // Rajout dans le code : le random (-1, 1) pour changer la direction de particule le faire aller dans toutes les directions positifs et négatifs
    float rn = random((-1), 1)*(noise((loc.x+frameCount+xOffset)*0.01*10, random((-1), 1)*(loc.y+frameCount+yOffset)*0.01)-0.5)*10*PI; //noise c'est la texture le buit et permet de le mettre dans l'espace 
    float mag = random((-1), 1)* noise((loc.y+frameCount)*0.01*10, random((-1), 1)* (loc.x+frameCount)*0.01)*10; // ligne qui défini la longeur de particule
    PVector dir = new PVector(cos(rn), sin(rn)); //PVector prend la valeur de  "newPVecto" qui aura pour direction cosinus x et en sinus x
    acc.add(dir);           //la longueur doit ajouter les valeurs de Pvector audessus :  acc(cos(rn),sin(rn))
    acc.mult(mag);          // (multiplier) acc(mag*cos(rn),mag*sin(rn))

    float randDegrees = random(360); //randDegrees : prend la valeur d'un nombre aléatoire d'un nombre de 0 et 360
    PVector randV = new PVector(cos(radians(randDegrees)), sin(radians(randDegrees))); // PVecteur qui peut prendre une direction aléatoire à 360°
    randV.mult(0.5);    //RandV se multiple par 0,5
    acc.add(randV);     //la longueur doit ajouter la valeur randV

    vel.add(acc);       // direction doit ajouter la longueur
    vel.mult(decay);    // direction se multiplie par decay
    vel.limit(3);       // sa valeur limite est 3
    loc.add(vel);       // localisation doit ajouter la direction 
 //----------------------fin des calcules pour la création d'une nouvelle particule-----------------------------
  }
  
  

//---------------paramètre d'affichage pour chaque particule à un moment donné---------------//
  void display() {
    strokeWeight(weight*2);      //contour extérieur de une particule rayon multiplié par 2 en pixel
    stroke(0, alpha);            //contour extérieur de particule : noir avec une transparence (extérieure de particule)
    point(loc.x, loc.y);         //les deux paramètres du dessus s'affichent à la position loc x et locy

    strokeWeight(weight);        //contour extérieur de une particule
    stroke(c);                   // ajoute la couleur préalablement définie à la particule
    point(loc.x, loc.y);         // et on lui donne sa position (superposition par rapport au contour définie auparavant)
  }
}
