/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.ChartData;
import java.util.ArrayList;
import java.util.ListIterator;
import processing.core.PGraphics;

public class ChartDataSet
extends ArrayList<ChartData> {
    protected CColor _myColor;
    protected float _myStrokeWeight = 1.0f;
    protected int[] colors = new int[0];
    protected final String _myName;

    public ChartDataSet(String string) {
        this._myName = string;
        this._myColor = new CColor();
    }

    public CColor getColor() {
        return this._myColor;
    }

    public ChartDataSet setColors(int ... nArray) {
        this.colors = nArray;
        return this;
    }

    public int[] getColors() {
        return this.colors;
    }

    public int getColor(int n) {
        if (this.colors.length == 0) {
            return this.getColor().getForeground();
        }
        if (this.colors.length == 2) {
            return PGraphics.lerpColor((int)this.colors[0], (int)this.colors[1], (float)((float)n / (float)this.size()), (int)1);
        }
        if (n >= 0 && n < this.colors.length) {
            return this.colors[n];
        }
        return this.getColor(0);
    }

    public ChartDataSet setStrokeWeight(float f) {
        this._myStrokeWeight = f;
        return this;
    }

    public float getStrokeWeight() {
        return this._myStrokeWeight;
    }

    public float[] getValues() {
        float[] fArray = new float[this.size()];
        int n = 0;
        ListIterator listIterator = this.listIterator();
        while (listIterator.hasNext()) {
            fArray[n++] = ((ChartData)listIterator.next()).getValue();
        }
        return fArray;
    }
}

