/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import processing.core.PFont;
import processing.core.PGraphics;

public class Icon
extends Controller<Icon> {
    protected boolean isPressed;
    protected boolean isOn = false;
    public static int autoWidth = 69;
    public static int autoHeight = 19;
    protected int activateBy = 2;
    protected boolean isSwitch = false;
    protected int roundedCorners = 0;
    protected boolean isFill = true;
    protected boolean isStroke = false;
    protected float scl = 1.0f;
    protected int[] fontIcons = new int[]{-1, -1, -1, -1};
    protected boolean isHideBackground = true;
    protected float strokeWeight = 1.0f;
    protected float scalePressed = 1.0f;
    protected float scaleReleased = 1.0f;

    public Icon(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0.0f, 0, 0, autoWidth, autoHeight);
        controlP5.register(controlP5.papplet, string, this);
    }

    protected Icon(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, float f, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myValue = f;
        this._myCaptionLabel.align(3, 3);
    }

    @Override
    protected void onEnter() {
        this.isActive = true;
    }

    @Override
    protected void onLeave() {
        this.isActive = false;
        this.setIsInside(false);
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        this.isActive = this.getIsInside();
        this.isPressed = true;
        if (this.activateBy == 1) {
            this.activate();
        }
        this.scl = this.scalePressed;
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleased() {
        this.isPressed = false;
        if (this.activateBy == 2) {
            this.activate();
        }
        this.isActive = false;
        this.scl = this.scaleReleased;
    }

    public Icon activateBy(int n) {
        this.activateBy = n == 1 ? 1 : 2;
        return this;
    }

    protected void activate() {
        if (this.isActive) {
            this.isActive = false;
            this.isOn = !this.isOn;
            this.setValue(this._myValue);
        }
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    @Override
    public Icon setValue(float f) {
        this._myValue = f;
        this.broadcast(2);
        return this;
    }

    @Override
    public Icon update() {
        return this.setValue(this._myValue);
    }

    public Icon setSwitch(boolean bl) {
        this.isSwitch = bl;
        this._myBroadcastType = this.isSwitch ? 3 : 2;
        return this;
    }

    public Icon setOn() {
        if (this.isSwitch) {
            this.isOn = false;
            this.isActive = true;
            this.activate();
        }
        return this;
    }

    public Icon setOff() {
        if (this.isSwitch) {
            this.isOn = true;
            this.isActive = true;
            this.activate();
        }
        return this;
    }

    public boolean isOn() {
        return this.isOn;
    }

    public boolean isSwitch() {
        return this.isSwitch;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public boolean getBooleanValue() {
        return this.isOn;
    }

    public Icon setRoundedCorners(int n) {
        this.roundedCorners = n;
        return this;
    }

    public Icon setFontIconSize(int n) {
        this._myCaptionLabel.setSize(n);
        return this;
    }

    @Override
    public Icon setFont(PFont pFont) {
        this._myCaptionLabel.setFont(pFont);
        return this;
    }

    public Icon setFont(PFont pFont, int n) {
        this._myCaptionLabel.setFont(pFont);
        this.setFontIconSize(n);
        return this;
    }

    public Icon setFontIndex(int n) {
        this._myCaptionLabel.set("" + (char)n);
        return this;
    }

    public Icon setStroke(boolean bl) {
        this.isStroke = bl;
        return this;
    }

    public Icon setStrokeWeight(float f) {
        this.strokeWeight = f;
        return this;
    }

    public Icon setFill(boolean bl) {
        this.isFill = bl;
        return this;
    }

    public Icon setFontIcons(int n, int n2) {
        this.setFontIcon(n2, 2);
        this.setFontIcon(n, 0);
        return this;
    }

    public Icon setFontIconOn(int n) {
        this.setFontIcon(n, 2);
        return this;
    }

    public Icon setFontIconOff(int n) {
        this.setFontIcon(n, 0);
        return this;
    }

    public Icon setFontIcons(int ... nArray) {
        if (nArray.length < 3 || nArray.length > 4) {
            return this;
        }
        this.setFontIcon(nArray[0], 0);
        this.setFontIcon(nArray[1], 1);
        this.setFontIcon(nArray[2], 2);
        this.setFontIcon(nArray.length == 3 ? nArray[2] : nArray[3], 3);
        return this;
    }

    public Icon setFontIcon(int n) {
        return this.setFontIcon(n, 0);
    }

    public int getFontIcon(int n) {
        if (n >= 0 && n < 4) {
            return this.fontIcons[n];
        }
        return this.fontIcons[0];
    }

    public Icon setFontIcon(int n, int n2) {
        this.fontIcons[n2] = n;
        this.updateDisplayMode(0);
        return this;
    }

    public Icon hideBackground() {
        this.isHideBackground = true;
        return this;
    }

    public Icon showBackground() {
        this.isHideBackground = false;
        return this;
    }

    public Icon setScale(float f, float f2) {
        this.scalePressed = f;
        this.scaleReleased = f2;
        return this;
    }

    @Override
    @ControlP5.Invisible
    public Icon updateDisplayMode(int n) {
        return this.updateViewMode(n);
    }

    @ControlP5.Invisible
    public Icon updateViewMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myControllerView = new IconView();
                break;
            }
            case 1: {
                this._myControllerView = new IconImageView();
                break;
            }
        }
        return this;
    }

    @Override
    public String getInfo() {
        return "type:\tIcon\n" + super.getInfo();
    }

    @Override
    public String toString() {
        return super.toString() + " [ " + this.getValue() + " ] " + "Icon" + " (" + this.getClass().getSuperclass() + ")";
    }

    private class IconImageView
    implements ControllerView<Icon> {
        private IconImageView() {
        }

        @Override
        public void display(PGraphics pGraphics, Icon icon) {
            float f = Icon.this.getWidth() / 2;
            float f2 = Icon.this.getHeight() / 2;
            pGraphics.translate(f, f2);
            pGraphics.scale(Icon.this.scl);
            if (Icon.this.isOn && Icon.this.isSwitch) {
                pGraphics.image(Icon.this.availableImages[3] ? Icon.this.images[3] : Icon.this.images[0], -f, -f2);
                return;
            }
            if (Icon.this.getIsInside()) {
                if (Icon.this.isPressed) {
                    pGraphics.image(Icon.this.availableImages[2] ? Icon.this.images[2] : Icon.this.images[0], -f, -f2);
                } else {
                    pGraphics.image(Icon.this.availableImages[1] ? Icon.this.images[1] : Icon.this.images[0], -f, -f2);
                }
            } else {
                pGraphics.image(Icon.this.images[0], -f, -f2);
            }
        }
    }

    private class IconView
    implements ControllerView<Icon> {
        private IconView() {
        }

        @Override
        public void display(PGraphics pGraphics, Icon icon) {
            if (!Icon.this.isHideBackground) {
                if (Icon.this.isStroke) {
                    pGraphics.stroke(Icon.this.color.getBackground());
                    pGraphics.strokeWeight(Icon.this.strokeWeight);
                } else {
                    pGraphics.noStroke();
                }
                if (Icon.this.isFill) {
                    pGraphics.fill(Icon.this.color.getBackground());
                } else {
                    pGraphics.noFill();
                }
            }
            float f = Icon.this.getWidth() / 2;
            float f2 = Icon.this.getHeight() / 2;
            pGraphics.translate(f, f2);
            pGraphics.scale(Icon.this.scl);
            if (!Icon.this.isHideBackground) {
                if (Icon.this.roundedCorners == 0) {
                    pGraphics.rect(-f, -f2, (float)Icon.this.getWidth(), (float)Icon.this.getHeight());
                } else if (Icon.this.roundedCorners == -1) {
                    pGraphics.ellipseMode(0);
                    pGraphics.ellipse(-f, -f2, (float)Icon.this.getWidth(), (float)Icon.this.getHeight());
                } else {
                    pGraphics.rect(-f, -f2, (float)Icon.this.getWidth(), (float)Icon.this.getHeight(), (float)Icon.this.roundedCorners, (float)Icon.this.roundedCorners, (float)Icon.this.roundedCorners, (float)Icon.this.roundedCorners);
                }
            }
            if (Icon.this.isSwitch) {
                if (!Icon.this.isOn) {
                    Icon.this.setFontIndex(Icon.this.getFontIcon(2));
                } else {
                    Icon.this.setFontIndex(Icon.this.getFontIcon(0));
                }
            } else {
                Icon.this.setFontIndex(Icon.this.getFontIcon(0));
            }
            Icon.this._myCaptionLabel.setColor(Icon.this.isOn && Icon.this.isSwitch || Icon.this.isPressed && !Icon.this.isSwitch ? Icon.this.color.getActive() : Icon.this.color.getForeground());
            Icon.this._myCaptionLabel.draw(pGraphics, -((int)f), -((int)(f2 * 1.05f)), icon);
        }
    }
}

