/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerView;
import controlP5.Label;
import controlP5.Tab;
import processing.core.PApplet;
import processing.core.PGraphics;

public class Numberbox
extends Controller<Numberbox> {
    protected int cnt;
    protected boolean isActive;
    public static int LEFT = 0;
    public static int UP = 1;
    public static int RIGHT = 2;
    public static int DOWN = 3;
    protected int _myNumberCount = 1;
    protected float _myMultiplier = 1.0f;
    public static int autoWidth = 69;
    public static int autoHeight = 19;
    protected float[] autoSpacing = new float[]{10.0f, 20.0f};
    protected float scrollSensitivity = 0.1f;

    public Numberbox(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0.0f, 0, 0, autoWidth, autoHeight);
        controlP5.register(controlP5.papplet, string, this);
    }

    public Numberbox(ControlP5 controlP5, Tab tab, String string, float f, int n, int n2, int n3, int n4) {
        super(controlP5, tab, string, n, n2, n3, n4);
        this._myMin = -3.4028235E38f;
        this._myMax = Float.MAX_VALUE;
        this._myValue = f;
        this._myValueLabel = new Label(this.cp5, "" + this._myValue, n3, 12, this.color.getValueLabel());
        if (Float.isNaN(this._myValue)) {
            this._myValue = 0.0f;
        }
    }

    @Override
    @ControlP5.Invisible
    public Numberbox updateInternalEvents(PApplet pApplet) {
        if (this.isActive && !this.cp5.isAltDown()) {
            if (this._myNumberCount == 1) {
                this.setValue(this._myValue + (float)(this._myControlWindow.mouseY - this._myControlWindow.pmouseY) * this._myMultiplier);
            } else {
                this.setValue(this._myValue + (float)(this._myControlWindow.mouseX - this._myControlWindow.pmouseX) * this._myMultiplier);
            }
        }
        return this;
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        this.isActive = true;
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleased() {
        this.isActive = false;
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    public Numberbox setMultiplier(float f) {
        this._myMultiplier = f;
        return this;
    }

    public float getMultiplier() {
        return this._myMultiplier;
    }

    @Override
    public Numberbox setValue(float f) {
        this._myValue = f;
        this._myValue = Math.max(this._myMin, Math.min(this._myMax, this._myValue));
        this.broadcast(2);
        this._myValueLabel.set(this.adjustValue(this._myValue));
        return this;
    }

    public Numberbox shuffle() {
        float f = (float)Math.random();
        if (this.getMax() != Float.MAX_VALUE && this.getMin() != -3.4028235E38f) {
            this.setValue(PApplet.map((float)f, (float)0.0f, (float)1.0f, (float)this.getMin(), (float)this.getMax()));
        }
        return this;
    }

    public Numberbox setRange(float f, float f2) {
        this.setMin(f);
        this.setMax(f2);
        this.setValue(this.getValue());
        return this;
    }

    public Numberbox setScrollSensitivity(float f) {
        this.scrollSensitivity = f;
        return this;
    }

    @ControlP5.Invisible
    public Numberbox scrolled(int n) {
        float f = this.getValue();
        this.setValue(f += this._myMultiplier == 1.0f ? (float)n * this.scrollSensitivity : (float)n * this._myMultiplier);
        return this;
    }

    public Numberbox setDirection(int n) {
        this._myNumberCount = n == 0 || n == 1 ? n : 1;
        return this;
    }

    @Override
    public Numberbox update() {
        return this.setValue(this._myValue);
    }

    @Override
    public Numberbox linebreak() {
        this.cp5.linebreak(this, true, autoWidth, autoHeight, this.autoSpacing);
        return this;
    }

    @Override
    @ControlP5.Invisible
    public Numberbox updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myControllerView = new NumberboxView();
            }
        }
        return this;
    }

    @Deprecated
    public Numberbox setSensitivity(float f) {
        return this.setScrollSensitivity(f);
    }

    class NumberboxView
    implements ControllerView<Numberbox> {
        NumberboxView() {
            Numberbox.this._myValueLabel.align(LEFT, 3).setPadding(0, Label.paddingY);
            Numberbox.this._myCaptionLabel.align(LEFT, 13).setPadding(0, Label.paddingY);
        }

        @Override
        public void display(PGraphics pGraphics, Numberbox numberbox) {
            pGraphics.fill(Numberbox.this.color.getBackground());
            pGraphics.rect(0.0f, 0.0f, (float)Numberbox.this.getWidth(), (float)Numberbox.this.getHeight());
            pGraphics.fill(Numberbox.this.isActive ? Numberbox.this.color.getActive() : Numberbox.this.color.getForeground());
            int n = Numberbox.this.getHeight() / 2;
            pGraphics.triangle(0.0f, (float)(n - 6), 6.0f, (float)n, 0.0f, (float)(n + 6));
            Numberbox.this._myValueLabel.draw(pGraphics, 10, 0, numberbox);
            Numberbox.this._myCaptionLabel.draw(pGraphics, 0, 0, numberbox);
        }
    }
}

