/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import controlP5.Label;
import processing.core.PApplet;
import processing.core.PGraphics;

public class Slider2D
extends Controller<Slider2D> {
    protected int cursorWidth = 6;
    protected int cursorHeight = 6;
    protected float cursorX;
    protected float cursorY;
    protected float _myMinX;
    protected float _myMinY;
    protected float _myMaxX;
    protected float _myMaxY;
    public boolean isCrosshairs = true;
    private String _myValueLabelSeparator = ",";

    public Slider2D(ControlP5 controlP5, String string) {
        this(controlP5, (ControllerGroup<?>)controlP5.getDefaultTab(), string, 0, 0, 99, 9);
        controlP5.register(controlP5.papplet, string, this);
    }

    protected Slider2D(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myArrayValue = new float[]{0.0f, 0.0f};
        this._myMinX = 0.0f;
        this._myMinY = 0.0f;
        this._myMaxX = n3;
        this._myMaxY = n4;
        this.getCaptionLabel().setPadding(0, Label.paddingY).align(37, 13);
        this.getValueLabel().setPadding(0, Label.paddingY).align(39, 13);
    }

    @Override
    @ControlP5.Invisible
    public Slider2D updateInternalEvents(PApplet pApplet) {
        if (this.isInside() && !this.cp5.isAltDown()) {
            float f = PApplet.constrain((float)((float)this._myControlWindow.mouseX - (Slider2D.x(this._myParent.getAbsolutePosition()) + Slider2D.x(this.position))), (float)0.0f, (float)(this.getWidth() - this.cursorWidth));
            float f2 = PApplet.constrain((float)((float)this._myControlWindow.mouseY - (Slider2D.y(this._myParent.getAbsolutePosition()) + Slider2D.y(this.position))), (float)0.0f, (float)(this.getHeight() - this.cursorHeight));
            if (this.isMousePressed) {
                this.cursorX = f;
                this.cursorY = f2;
                this.updateValue();
            }
        }
        return this;
    }

    Slider2D updateValue() {
        return this.setValue(0.0f);
    }

    public Slider2D setMinMax(float f, float f2, float f3, float f4) {
        this._myMinX = f;
        this._myMinY = f2;
        this._myMaxX = f3;
        this._myMaxY = f4;
        return this.setValue(this._myArrayValue[0], this._myArrayValue[1]);
    }

    public Slider2D setMinX(float f) {
        this._myMinX = f;
        return this.updateValue();
    }

    public Slider2D setMinY(float f) {
        this._myMinY = f;
        return this.updateValue();
    }

    public Slider2D setMaxX(float f) {
        this._myMaxX = f;
        return this.updateValue();
    }

    public Slider2D setMaxY(float f) {
        this._myMaxY = f;
        return this.updateValue();
    }

    public float getMinX() {
        return this._myMinX;
    }

    public float getMinY() {
        return this._myMinY;
    }

    public float getMaxX() {
        return this._myMaxX;
    }

    public float getMaxY() {
        return this._myMaxY;
    }

    public float getCursorX() {
        return this.cursorX;
    }

    public float getCursorY() {
        return this.cursorY;
    }

    public float getCursorWidth() {
        return this.cursorWidth;
    }

    public float getCursorHeight() {
        return this.cursorHeight;
    }

    public Slider2D disableCrosshair() {
        this.isCrosshairs = false;
        return this;
    }

    public Slider2D enableCrosshair() {
        this.isCrosshairs = true;
        return this;
    }

    @Override
    public Slider2D setArrayValue(float[] fArray) {
        this._myArrayValue = fArray;
        float f = (float)(this.getWidth() - this.cursorWidth) / (this._myMaxX - this._myMinX);
        float f2 = (float)(this.getHeight() - this.cursorHeight) / (this._myMaxY - this._myMinY);
        this.cursorX = PApplet.constrain((float)(fArray[0] * f), (float)0.0f, (float)(this.getWidth() - this.cursorWidth));
        this.cursorY = PApplet.constrain((float)(fArray[1] * f2), (float)0.0f, (float)(this.getHeight() - this.cursorHeight));
        return this.updateValue();
    }

    @Override
    public float[] getArrayValue() {
        return this._myArrayValue;
    }

    public Slider2D setCursorX(float f) {
        return this.setArrayValue(new float[]{f, this.getArrayValue()[1]});
    }

    public Slider2D setCursorY(float f) {
        return this.setArrayValue(new float[]{this.getArrayValue()[0], f});
    }

    @Override
    public Slider2D setValue(float f) {
        this._myArrayValue[0] = this.cursorX / ((float)(this.getWidth() - this.cursorWidth) / (float)this.getWidth());
        this._myArrayValue[1] = this.cursorY / ((float)(this.getHeight() - this.cursorHeight) / (float)this.getHeight());
        this._myArrayValue[0] = PApplet.map((float)this._myArrayValue[0], (float)0.0f, (float)this.getWidth(), (float)this._myMinX, (float)this._myMaxX);
        this._myArrayValue[1] = PApplet.map((float)this._myArrayValue[1], (float)0.0f, (float)this.getHeight(), (float)this._myMinY, (float)this._myMaxY);
        this._myValueLabel.set(this.adjustValue(this._myArrayValue[0], 0) + this._myValueLabelSeparator + this.adjustValue(this._myArrayValue[1], 0));
        this.broadcast(2);
        return this;
    }

    public Slider2D setValue(float f, float f2) {
        this.cursorX = PApplet.map((float)f, (float)this._myMinX, (float)this._myMaxX, (float)0.0f, (float)(this.getWidth() - this.cursorWidth));
        this.cursorY = PApplet.map((float)f2, (float)this._myMinY, (float)this._myMaxY, (float)0.0f, (float)(this.getHeight() - this.cursorHeight));
        return this.setValue(0.0f);
    }

    public Slider2D shuffle() {
        float f = (float)Math.random();
        float f2 = (float)Math.random();
        this._myArrayValue[0] = f * (float)this.getWidth();
        this._myArrayValue[0] = f2 * (float)this.getHeight();
        return this.setValue(0.0f);
    }

    public void setValueLabelSeparator(String string) {
        this._myValueLabelSeparator = string;
    }

    @Override
    @ControlP5.Invisible
    public Slider2D updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myControllerView = new Slider2DView();
                break;
            }
        }
        return this;
    }

    class Slider2DView
    implements ControllerView<Slider2D> {
        Slider2DView() {
        }

        @Override
        public void display(PGraphics pGraphics, Slider2D slider2D) {
            pGraphics.noStroke();
            pGraphics.fill(slider2D.getColor().getBackground());
            pGraphics.rect(0.0f, 0.0f, (float)Slider2D.this.getWidth(), (float)Slider2D.this.getHeight());
            pGraphics.fill(slider2D.isInside ? slider2D.getColor().getActive() : slider2D.getColor().getForeground());
            pGraphics.rect((float)((int)Slider2D.this.getCursorX()), (float)((int)Slider2D.this.getCursorY()), (float)((int)Slider2D.this.getCursorWidth()), (float)((int)Slider2D.this.getCursorHeight()));
            if (Slider2D.this.isCrosshairs) {
                pGraphics.rect(0.0f, (float)((int)(Slider2D.this.getCursorY() + Slider2D.this.getCursorHeight() / 2.0f)), (float)Slider2D.this.getWidth(), 1.0f);
                pGraphics.rect((float)((int)(Slider2D.this.getCursorX() + Slider2D.this.getCursorWidth() / 2.0f)), 0.0f, 1.0f, (float)Slider2D.this.getHeight());
            }
            Slider2D.this.getCaptionLabel().draw(pGraphics, 0, 0, slider2D);
            Slider2D.this.getValueLabel().draw(pGraphics, 0, 0, slider2D);
        }
    }
}

