/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.raster;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.NyARRaster_BasicClass;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARGrayscaleRaster
extends NyARRaster_BasicClass {
    private IdoFilterImpl _impl;
    protected Object _buf;
    protected boolean _is_attached_buffer;

    public NyARGrayscaleRaster(int i_width, int i_height) throws NyARException {
        super(i_width, i_height, 262145);
        if (!this.initInstance(this._size, 262145, true)) {
            throw new NyARException();
        }
    }

    public NyARGrayscaleRaster(int i_width, int i_height, boolean i_is_alloc) throws NyARException {
        super(i_width, i_height, 262145);
        if (!this.initInstance(this._size, 262145, i_is_alloc)) {
            throw new NyARException();
        }
    }

    public NyARGrayscaleRaster(int i_width, int i_height, int i_raster_type, boolean i_is_alloc) throws NyARException {
        super(i_width, i_height, i_raster_type);
        if (!this.initInstance(this._size, i_raster_type, i_is_alloc)) {
            throw new NyARException();
        }
    }

    protected boolean initInstance(NyARIntSize i_size, int i_buf_type, boolean i_is_alloc) {
        switch (i_buf_type) {
            case 262145: {
                this._impl = new IdoFilterImpl_INT1D_GRAY_8();
                this._buf = i_is_alloc ? new int[i_size.w * i_size.h] : null;
                break;
            }
            default: {
                return false;
            }
        }
        this._is_attached_buffer = i_is_alloc;
        return true;
    }

    @Override
    public Object getBuffer() {
        return this._buf;
    }

    @Override
    public boolean hasBuffer() {
        return this._buf != null;
    }

    @Override
    public void wrapBuffer(Object i_ref_buf) throws NyARException {
        assert (!this._is_attached_buffer);
        this._buf = i_ref_buf;
    }

    public void fill(int i_value) {
        this._impl.fill(this, i_value);
    }

    public void copyTo(int i_left, int i_top, int i_skip, NyARGrayscaleRaster o_output) {
        assert (this.getSize().isInnerSize(i_left + o_output.getWidth() * i_skip, i_top + o_output.getHeight() * i_skip));
        assert (this.isEqualBufferType(o_output.getBufferType()));
        this._impl.copyTo(this, i_left, i_top, i_skip, o_output);
    }

    protected static interface IdoFilterImpl {
        public void fill(NyARGrayscaleRaster var1, int var2);

        public void copyTo(NyARGrayscaleRaster var1, int var2, int var3, int var4, NyARGrayscaleRaster var5);
    }

    protected final class IdoFilterImpl_INT1D_GRAY_8
    implements IdoFilterImpl {
        protected IdoFilterImpl_INT1D_GRAY_8() {
        }

        @Override
        public void fill(NyARGrayscaleRaster i_raster, int i_value) {
            assert (i_raster._buffer_type == 262145);
            int[] buf = (int[])i_raster._buf;
            int i = i_raster._size.h * i_raster._size.w - 1;
            while (i >= 0) {
                buf[i] = i_value;
                --i;
            }
        }

        @Override
        public void copyTo(NyARGrayscaleRaster i_input, int i_left, int i_top, int i_skip, NyARGrayscaleRaster o_output) {
            assert (i_input.getSize().isInnerSize(i_left + o_output.getWidth() * i_skip, i_top + o_output.getHeight() * i_skip));
            int[] input = (int[])i_input.getBuffer();
            int[] output = (int[])o_output.getBuffer();
            NyARIntSize dest_size = o_output.getSize();
            NyARIntSize src_size = i_input.getSize();
            int skip_src_y = src_size.w - dest_size.w * i_skip + src_size.w * (i_skip - 1);
            int pix_count = dest_size.w;
            int pix_mod_part = pix_count - pix_count % 8;
            int pt_dst = 0;
            int pt_src = i_top * src_size.w + i_left;
            int y = dest_size.h - 1;
            while (y >= 0) {
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    output[pt_dst++] = input[pt_src];
                    pt_src += i_skip;
                    --x;
                }
                while (x >= 0) {
                    output[pt_dst++] = input[pt_src];
                    output[pt_dst++] = input[pt_src += i_skip];
                    output[pt_dst++] = input[pt_src += i_skip];
                    output[pt_dst++] = input[pt_src += i_skip];
                    output[pt_dst++] = input[pt_src += i_skip];
                    output[pt_dst++] = input[pt_src += i_skip];
                    output[pt_dst++] = input[pt_src += i_skip];
                    output[pt_dst++] = input[pt_src += i_skip];
                    pt_src += i_skip;
                    x -= 8;
                }
                pt_src += skip_src_y;
                --y;
            }
        }
    }
}

