/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.detector;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationColorData;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattResult;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPatt_Color_WITHOUT_PCA;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin.INyARRasterFilter_Rgb2Bin;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARCoord2Linear;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARRectOffset;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.NyARIntCoordinates;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public abstract class NyARCustomSingleDetectMarker {
    private double _confidence;
    private NyARSquare _square = new NyARSquare();
    private INyARRgbRaster _ref_raster;
    private INyARColorPatt _inst_patt;
    private NyARMatchPattDeviationColorData _deviation_data;
    private NyARMatchPatt_Color_WITHOUT_PCA _match_patt;
    private final NyARMatchPattResult __detectMarkerLite_mr = new NyARMatchPattResult();
    private NyARCoord2Linear _coordline;
    private NyARIntPoint2d[] __ref_vertex = new NyARIntPoint2d[4];
    private boolean _is_continue = false;
    private NyARSquareContourDetector _square_detect;
    private NyARRectOffset _offset;
    private NyARBinRaster _bin_raster;
    private INyARTransMat _transmat;
    protected INyARRasterFilter_Rgb2Bin _tobin_filter;

    protected void updateSquareInfo(NyARIntCoordinates i_coord, int[] i_vertex_index) throws NyARException {
        NyARMatchPattResult mr = this.__detectMarkerLite_mr;
        NyARIntPoint2d[] vertex = this.__ref_vertex;
        vertex[0] = i_coord.items[i_vertex_index[0]];
        vertex[1] = i_coord.items[i_vertex_index[1]];
        vertex[2] = i_coord.items[i_vertex_index[2]];
        vertex[3] = i_coord.items[i_vertex_index[3]];
        if (!this._inst_patt.pickFromRaster(this._ref_raster, vertex)) {
            return;
        }
        this._deviation_data.setRaster(this._inst_patt);
        if (!this._match_patt.evaluate(this._deviation_data, mr)) {
            return;
        }
        if (this._confidence > mr.confidence) {
            return;
        }
        NyARSquare sq = this._square;
        this._confidence = mr.confidence;
        int i = 0;
        while (i < 4) {
            int idx = (i + 4 - mr.direction) % 4;
            this._coordline.coord2Line(i_vertex_index[idx], i_vertex_index[(idx + 1) % 4], i_coord, sq.line[i]);
            ++i;
        }
        i = 0;
        while (i < 4) {
            if (!sq.line[i].crossPos(sq.line[(i + 3) % 4], sq.sqvertex[i])) {
                throw new NyARException();
            }
            ++i;
        }
    }

    protected NyARCustomSingleDetectMarker() {
    }

    protected void initInstance(INyARColorPatt i_patt_inst, NyARSquareContourDetector i_sqdetect_inst, INyARTransMat i_transmat_inst, INyARRasterFilter_Rgb2Bin i_filter, NyARParam i_ref_param, NyARCode i_ref_code, double i_marker_width) throws NyARException {
        NyARIntSize scr_size = i_ref_param.getScreenSize();
        this._square_detect = i_sqdetect_inst;
        this._transmat = i_transmat_inst;
        this._tobin_filter = i_filter;
        this._bin_raster = new NyARBinRaster(scr_size.w, scr_size.h);
        this._inst_patt = i_patt_inst;
        this._deviation_data = new NyARMatchPattDeviationColorData(i_ref_code.getWidth(), i_ref_code.getHeight());
        this._coordline = new NyARCoord2Linear(i_ref_param.getScreenSize(), i_ref_param.getDistortionFactor());
        this._match_patt = new NyARMatchPatt_Color_WITHOUT_PCA(i_ref_code);
        this._offset = new NyARRectOffset();
        this._offset.setSquare(i_marker_width);
    }

    protected boolean detectMarkerLite(INyARRgbRaster i_raster) throws NyARException {
        if (!this._bin_raster.getSize().isEqualSize(i_raster.getSize())) {
            throw new NyARException();
        }
        this._tobin_filter.doFilter(i_raster, this._bin_raster);
        this._confidence = 0.0;
        this._ref_raster = i_raster;
        this._square_detect.detectMarker(this._bin_raster);
        return this._confidence != 0.0;
    }

    public void getTransmationMatrix(NyARTransMatResult o_result) throws NyARException {
        if (this._is_continue) {
            this._transmat.transMatContinue(this._square, this._offset, o_result, o_result);
        } else {
            this._transmat.transMat(this._square, this._offset, o_result);
        }
    }

    public NyARSquare refSquare() {
        return this._square;
    }

    public double getConfidence() {
        return this._confidence;
    }

    public void setContinueMode(boolean i_is_continue) {
        this._is_continue = i_is_continue;
    }

    public Object[] _getProbe() {
        Object[] r = new Object[]{this._inst_patt};
        return r;
    }
}

