/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PVector;
import saito.objloader.Face;
import saito.objloader.OBJModel;
import saito.objloader.Segment;

public class OBJLoader_FaceLocation_MATTD
extends PApplet {
    OBJModel model;
    float rotX;
    float rotY;
    float normLength = -25.0f;
    PVector pos = new PVector(0.0f, 0.0f, 0.0f);
    PVector dir = new PVector(1.0f, 0.0f, 0.0f);
    AABB volume;

    public void setup() {
        this.size(600, 600, "processing.core.PGraphics3D");
        this.model = new OBJModel((PApplet)this, "cubic_sphere.obj");
        this.model.scale(3.0f);
        this.model.translateToCenter();
        this.volume = new AABB(0.0f, -150.0f, -150.0f, 40.0f, 150.0f, 150.0f);
    }

    public void draw() {
        this.pos.add(this.dir);
        if (this.pos.x > 200.0f || this.pos.x < -200.0f) {
            this.dir.mult(-1.0f);
        }
        this.volume.moveCenterTo(this.pos);
        this.background(32);
        this.lights();
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.rotateX(this.rotY);
        this.rotateY(this.rotX);
        this.volume.draw();
        this.noStroke();
        int n = 0;
        while (n < this.model.getSegmentCount()) {
            Segment segment = this.model.getSegment(n);
            Face[] faceArray = segment.getFaces();
            this.beginShape(16);
            int n2 = 0;
            while (n2 < faceArray.length) {
                Face face = faceArray[n2];
                if (this.volume.isColliding(face.getCenter())) {
                    PVector[] pVectorArray = face.getVertices();
                    PVector[] pVectorArray2 = face.getNormals();
                    int n3 = 0;
                    while (n3 < pVectorArray.length) {
                        this.normal(pVectorArray2[n3].x, pVectorArray2[n3].y, pVectorArray2[n3].z);
                        this.vertex(pVectorArray[n3].x, pVectorArray[n3].y, pVectorArray[n3].z);
                        ++n3;
                    }
                }
                ++n2;
            }
            this.endShape();
            ++n;
        }
        this.popMatrix();
    }

    public void mouseDragged() {
        this.rotX += (float)(this.mouseX - this.pmouseX) * 0.01f;
        this.rotY -= (float)(this.mouseY - this.pmouseY) * 0.01f;
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "OBJLoader_FaceLocation_MATTD"});
    }

    class AABB {
        PVector min = new PVector();
        PVector max = new PVector();

        AABB() {
            this.min.set(0.0f, 0.0f, 0.0f);
            this.max.set(0.0f, 0.0f, 0.0f);
        }

        AABB(float f, float f2, float f3, float f4, float f5, float f6) {
            this.reset();
            this.addPoint(f, f2, f3);
            this.addPoint(f4, f5, f6);
        }

        AABB(PVector pVector, PVector pVector2) {
            this.reset();
            this.addPoint(pVector);
            this.addPoint(pVector2);
        }

        public void reset() {
            this.min.x = Float.MAX_VALUE;
            this.min.y = Float.MAX_VALUE;
            this.min.z = Float.MAX_VALUE;
            this.max.x = -3.4028235E38f;
            this.max.y = -3.4028235E38f;
            this.max.z = -3.4028235E38f;
        }

        public void addPoint(PVector pVector) {
            this.addPoint(pVector.x, pVector.y, pVector.z);
        }

        public void addPoint(float f, float f2, float f3) {
            if (f < this.min.x) {
                this.min.x = f;
            }
            if (f > this.max.x) {
                this.max.x = f;
            }
            if (f2 < this.min.y) {
                this.min.y = f2;
            }
            if (f2 > this.max.y) {
                this.max.y = f2;
            }
            if (f3 < this.min.z) {
                this.min.z = f3;
            }
            if (f3 > this.max.z) {
                this.max.z = f3;
            }
        }

        public void moveCenterTo(PVector pVector) {
            PVector pVector2 = new PVector(this.min.x, this.min.y, this.min.z);
            PVector pVector3 = new PVector(this.max.x, this.max.y, this.max.z);
            pVector3.sub(pVector2);
            pVector3.div(2.0f);
            pVector3.add(this.min);
            PVector pVector4 = new PVector(pVector.x, pVector.y, pVector.z);
            pVector4.sub(pVector3);
            this.min.add(pVector4);
            this.max.add(pVector4);
        }

        public void draw() {
            OBJLoader_FaceLocation_MATTD.this.pushStyle();
            OBJLoader_FaceLocation_MATTD.this.noFill();
            OBJLoader_FaceLocation_MATTD.this.stroke(255.0f, 0.0f, 255.0f);
            OBJLoader_FaceLocation_MATTD.this.pushMatrix();
            PVector pVector = new PVector(this.max.x, this.max.y, this.max.z);
            pVector.sub(this.min);
            pVector.div(2.0f);
            pVector.add(this.min);
            PVector pVector2 = new PVector(this.max.x, this.max.y, this.max.z);
            pVector2.sub(this.min);
            OBJLoader_FaceLocation_MATTD.this.translate(pVector.x, pVector.y, pVector.z);
            OBJLoader_FaceLocation_MATTD.this.box(pVector2.x, pVector2.y, pVector2.z);
            OBJLoader_FaceLocation_MATTD.this.popMatrix();
            OBJLoader_FaceLocation_MATTD.this.popStyle();
        }

        public boolean isColliding(PVector pVector) {
            return this.isColliding(pVector.x, pVector.y, pVector.z);
        }

        public boolean isColliding(float f, float f2, float f3) {
            if (this.min.x > f) {
                return false;
            }
            if (this.max.x < f) {
                return false;
            }
            if (this.min.y > f2) {
                return false;
            }
            if (this.max.y < f2) {
                return false;
            }
            if (this.min.z > f3) {
                return false;
            }
            return !(this.max.z < f3);
        }
    }
}

