/*
 * Decompiled with CFR 0.152.
 */
package saito.tests;

import processing.core.PApplet;
import processing.core.PVector;
import saito.objloader.Face;
import saito.objloader.OBJModel;
import saito.objloader.Segment;

public class FaceNormalsTest
extends PApplet {
    OBJModel model;
    float rotX;
    float rotY;
    int faceCount;
    int faceIndex;
    float normLength = -25.0f;
    float normDir = 1.0f;

    public void setup() {
        this.size(600, 600, "processing.core.PGraphics3D");
        this.model = new OBJModel(this);
        this.model.load("map_ground_path_s.obj");
        this.model.scale(150.0f);
        this.model.translateToCenter();
        this.faceCount = this.model.getIndexCountInSegment(0);
    }

    public void draw() {
        this.background(32);
        this.lights();
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.rotateX(this.rotY);
        this.rotateY(this.rotX);
        int j = 0;
        while (j < this.model.getSegmentCount()) {
            Segment segment = this.model.getSegment(j);
            Face[] faces = segment.getFaces();
            this.noStroke();
            this.fill(196);
            this.beginShape(16);
            int i = 0;
            while (i < faces.length) {
                Face f = faces[i];
                PVector[] vs = f.getVertices();
                int k = 0;
                while (k < vs.length) {
                    this.vertex(vs[k].x, vs[k].y, vs[k].z);
                    ++k;
                }
                ++i;
            }
            this.endShape();
            i = 0;
            while (i < faces.length) {
                PVector v = faces[i].getCenter();
                PVector n = faces[i].getNormal();
                this.stroke(255.0f, 0.0f, 255.0f);
                this.beginShape(4);
                this.vertex(v.x, v.y, v.z);
                this.vertex(v.x + n.x * this.normLength, v.y + n.y * this.normLength, v.z + n.z * this.normLength);
                this.endShape();
                ++i;
            }
            ++j;
        }
        this.popMatrix();
    }

    public void mouseDragged() {
        this.rotX = (float)((double)this.rotX + (double)(this.mouseX - this.pmouseX) * 0.01);
        this.rotY = (float)((double)this.rotY - (double)(this.mouseY - this.pmouseY) * 0.01);
    }
}

