/*
*
*
*
Marine Espinasse, DSAA 1 Design Graphique
Dans le cadre du cours de M. Muti
Prototype d'un jeu pacman.

ATTENTION : ce programme n'est pas encore
parfaitement fonctionnel : il présente des
latences dans le déplacement du personnage,
oblige le joueur à spammer les touches pour
rammasser les billes, et ne fais pas "mourir"
le joueur au contact des fantômes.
*
*
*
*/

class Fantome 
{
  
  //Déclaration des attributs
  color couleur;
  PVector position, direction;
  int etat, taille, vitesse;

  // Constructeur
  Fantome(int x, int y, int t, color c) 
  {
    position = new PVector(x * t + t / 2, y * t + t / 2);
    direction = new PVector(2 * int(random(2)) - 1, 0);
    couleur = c;
    etat = 0;
    taille = t;
    vitesse = 2;
  }

  // Gérer le déplacement aléatoire des fantomes
  PVector croisement(int[][] t, int x, int y) 
  {
    byte dir = 0;
    byte n = 0;
    if (t[x][y - 1] != 0) 
    {
      dir |= (1 << 0);
      n++;
    }
    if (t[x + 1][y] != 0) 
    {
      dir |= (1 << 1);
      n++;
    }
    if (t[x][y + 1] != 0) 
    {
      dir |= (1 << 2);
      n++;
    }
    if (t[x - 1][y] != 0) 
    {
      dir |= (1 << 3);
      n++;
    }
    if (n == 1) 
    {
      return PVector.mult(direction, -1);
    } else 
    {
      int choix = 0;
      PVector res = new PVector(0, 0);
      while (choix == 0) 
      {
        choix = dir & (1 << int(random(4)));
        switch (choix) 
        {
          case 1 :
          res.set(0, -1);
          break;
          case 2 :
          res.set(1, 0);
          break;
          case 4 : 
          res.set(0, 1);
          break;
          case 8 :
          res.set(-1, 0);
          break;
        }
        if (res.dist(direction) == 2) 
        {
          choix = 0;
        }
      }
     return res;
    }
  }

  // Déclaration des méthodes
  void deplacement(int[][] t)
  {
    int caseX = taille * ((int)position.x / taille) + taille / 2;
    int caseY = taille * ((int)position.y / taille) + taille / 2;
    if ((position.x == caseX) && (position.y == caseY)) 
    {
      direction.set(croisement(t, (int)position.x / taille, (int)position.y / taille));
    }
    position.add(PVector.mult(direction, vitesse));
  }

  void affichage() 
  {
    pushMatrix();
    translate(position.x, position.y);
    switch (etat) 
    {
      // Dessin des fantomes
    case 0: 
      fill(couleur);
      arc(taille / 2-25, taille / 2-32, 30, 30, -PI, 0);
      rect(taille / 2- 40, taille / 2 - 32, 30, 15);
      triangle(taille/2 - 40,taille/2-17 , taille/2 -30, taille/2-17, taille/2 -40, taille/2-10);
      triangle(taille/2 - 33,taille/2-17 , taille/2 -18, taille/2-17, taille/2 -25, taille/2-10);
      triangle(taille/2 - 20,taille/2-17 , taille/2 -10, taille/2-17, taille/2 -10, taille/2-10);
      fill(0);
      ellipse(taille/2-30, taille/2-33, 8,8);
      ellipse(taille/2-20, taille/2-33, 8,8);
      fill(#2B45EA);
      ellipse(taille/2-31, taille/2-32, 3,4);
      ellipse(taille/2-21, taille/2-32, 3,4);
    }
    popMatrix();
  };
}