
/*

  Alycia Rainaud
  Premier test pour un programme de réalité augmentée.
  Gestion de plusieurs marqueurs
  À régler : importation des textures à revoir
  
*/


import processing.video.*; // Importer la librairie Vidéo, permet d'appeler la webcam par exemple
import jp.nyatla.nyar4psg.*; // Importer la librairie Nyar4Psg, permet la réalité augmentée
import saito.objloader.*; // Impporter la librairie OBJLoader, permet d'importer des objets 3D
import processing.opengl.*; // Importer la librairie OPENGL, permet de gérer la 3D et les rendus de textures etc


Capture cam; // Déclaration de la variable caméra
MultiMarker nya; // Déclaration de la variable Nyar
OBJModel model; // Déclaration de la variable objet model


// Variables à utiliser lorsque l'import de texture marche
//boolean bTexture = false;
//boolean bStroke = false;
//boolean bMaterial = false;


// Initialisation des paramètres d'affichages
void setup() {
  size(640,480,P3D); // Taille de la fenêtre + appel de la 3D
  colorMode(RGB); // Mode colorimétrique
  cam=new Capture(this,width,height); // Taille de la caméra
  // Appel de la fonction MultiMarker (reconnaissance multiples des marqueurs)
  nya=new MultiMarker(this,width,height,"camera_para.dat",new NyAR4PsgConfig(NyAR4PsgConfig.CS_RIGHT_HAND,NyAR4PsgConfig.TM_NYARTK));
  nya.addARMarker("patt.hiro",80); // Marqueur 1 + taille
  nya.addARMarker("patt.kanji",80); // Marqueur 2 + taille
  nya.addARMarker("4x4_1.patt",80); // Marqueur 3 + taille
  
  // Appel d'un modèle 3D format .obj créé dans blender
  model = new OBJModel(this, "data/circle.obj", "absolute", TRIANGLES); // Création d'un nouvel objet appelé model, instancié par OBJModel
  model.enableDebug(); // fonction de débug
  model.scale(20); // taille de l'objet
  model.translateToCenter(); // Centrer l'objet sur le marqueur
  
}





// Initilisation des boucles d'affichages
void draw() {

  // Vérification de l'activation de la caméra
  if (cam.available() !=true) {
    return;
  }
  
  
  background(0); // !!! si cette ligne est supprimée, on peut dessiner avec l'objet du marqueur
  cam.read(); // Lecture de l'image caméra
  nya.drawBackground(cam); // Applique l'image de la caméra en fond
  nya.detect(cam); // Detection des marqueurs via la caméra
  
  
  
  
  // Boucles de vérifications des marqueurs
  
  // Premier marqueur
  if(nya.isExistMarker(0)){ // Si la caméra detecte un marqueur via Nyar
    nya.beginTransform(0); // Alors Nyar créé ou applique une transformation
    {
      
     // Apparition d'un cube
      fill(0,0,255); // Remplir de bleu
      translate(0,0,20); 
      translate(0,0,-20); 
      box(40); // Dessin d'un cube de 40px
      
      
      
    }
    nya.endTransform();  // Si Nyar ne détecte pas de marqueur alors il ne se passe rien
  }
  
  
  
  // Deuxième marqueur
  if(nya.isExistMarker(1)){ // Si la caméra detecte un marqueur via Nyar
    nya.beginTransform(1); // Alors Nyar créé ou applique une transformation
    {
      pushStyle();
      model.draw(); // Dessin de l'objet model
      lights();
      popStyle();
      
      
      
      // À note : problème d'importation de textures à régler  

    }
    nya.endTransform();  // Si Nyar ne détecte pas de marqueur alors il ne se passe rien
  }
 
 

 // Troisième marqueur
  if(nya.isExistMarker(2)){ // Si la caméra detecte un marqueur via Nyar
    nya.beginTransform(2); // Alors Nyar créé ou applique une transformation
    {
      
     // Apparition d'une sphère
        fill(255,255,0); // Remplir de jaune
        translate(0,0,30);
        translate(0,0,-30);
        sphere(30); // Dessin d'une sphere de 30px
        
        
      
    }
    nya.endTransform();  // Si Nyar ne détecte pas de marqueur alors il ne se passe rien
  }
 
 
}



// FIN DU PROGRAMME //






