/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.lowlevel;

import com.sun.jna.CallbackParameterContext;
import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.MethodParameterContext;
import com.sun.jna.MethodResultContext;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StructureReadContext;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.gstreamer.ClockTime;
import org.gstreamer.QueryType;
import org.gstreamer.glib.GQuark;
import org.gstreamer.lowlevel.EnumMapper;
import org.gstreamer.lowlevel.GlibAPI;
import org.gstreamer.lowlevel.Handle;
import org.gstreamer.lowlevel.IntPtr;
import org.gstreamer.lowlevel.NativeObject;
import org.gstreamer.lowlevel.NativeValue;
import org.gstreamer.lowlevel.RefCountedObject;
import org.gstreamer.lowlevel.annotations.CallerOwnsReturn;
import org.gstreamer.lowlevel.annotations.ConstField;
import org.gstreamer.lowlevel.annotations.FreeReturnValue;
import org.gstreamer.lowlevel.annotations.IncRef;
import org.gstreamer.lowlevel.annotations.Invalidate;

public class GTypeMapper
extends DefaultTypeMapper {
    private static ToNativeConverter nativeValueArgumentConverter = new ToNativeConverter(){

        public Object toNative(Object arg, ToNativeContext context) {
            return arg != null ? ((NativeValue)arg).nativeValue() : null;
        }

        public Class<?> nativeType() {
            return Void.class;
        }
    };
    private static TypeConverter clocktimeConverter = new TypeConverter(){

        public Object fromNative(Object arg, FromNativeContext arg1) {
            return ClockTime.valueOf((Long)arg, TimeUnit.NANOSECONDS);
        }

        public Class<?> nativeType() {
            return Long.TYPE;
        }

        public Object toNative(Object arg, ToNativeContext arg1) {
            return arg != null ? ((ClockTime)arg).convertTo(TimeUnit.NANOSECONDS) : 0L;
        }
    };
    private static TypeConverter nativeObjectConverter = new TypeConverter(){

        public Object toNative(Object arg, ToNativeContext context) {
            if (arg == null) {
                return null;
            }
            Pointer ptr = ((NativeObject)arg).handle();
            if (context instanceof MethodParameterContext) {
                Annotation[][] parameterAnnotations;
                MethodParameterContext mcontext = (MethodParameterContext)context;
                Method method = mcontext.getMethod();
                int index = mcontext.getParameterIndex();
                if (index < (parameterAnnotations = method.getParameterAnnotations()).length) {
                    Annotation[] annotations = parameterAnnotations[index];
                    for (int i = 0; i < annotations.length; ++i) {
                        if (annotations[i] instanceof Invalidate) {
                            ((Handle)arg).invalidate();
                            break;
                        }
                        if (!(annotations[i] instanceof IncRef)) continue;
                        ((RefCountedObject)arg).ref();
                        break;
                    }
                }
            }
            return ptr;
        }

        public Object fromNative(Object result, FromNativeContext context) {
            if (result == null) {
                return null;
            }
            if (context instanceof MethodResultContext) {
                boolean ownsHandle = ((MethodResultContext)context).getMethod().isAnnotationPresent(CallerOwnsReturn.class);
                int refadj = ownsHandle ? -1 : 0;
                return NativeObject.objectFor((Pointer)result, context.getTargetType(), refadj, ownsHandle);
            }
            if (context instanceof CallbackParameterContext) {
                return NativeObject.objectFor((Pointer)result, context.getTargetType(), 1, true);
            }
            if (context instanceof StructureReadContext) {
                StructureReadContext sctx = (StructureReadContext)context;
                boolean ownsHandle = sctx.getField().getAnnotation(ConstField.class) == null;
                return NativeObject.objectFor((Pointer)result, context.getTargetType(), 1, ownsHandle);
            }
            throw new IllegalStateException("Cannot convert to NativeObject from " + context);
        }

        public Class<?> nativeType() {
            return Pointer.class;
        }
    };
    private static TypeConverter enumConverter = new TypeConverter(){

        public Object fromNative(Object value, FromNativeContext context) {
            return EnumMapper.getInstance().valueOf((Integer)value, context.getTargetType());
        }

        public Class<?> nativeType() {
            return Integer.class;
        }

        public Object toNative(Object arg, ToNativeContext context) {
            if (arg == null) {
                return null;
            }
            return EnumMapper.getInstance().intValue((Enum)arg);
        }
    };
    private TypeConverter stringConverter = new TypeConverter(){

        public Object fromNative(Object result, FromNativeContext context) {
            if (result == null) {
                return null;
            }
            if (context instanceof MethodResultContext) {
                MethodResultContext functionContext = (MethodResultContext)context;
                Method method = functionContext.getMethod();
                Pointer ptr = (Pointer)result;
                String s = ptr.getString(0L);
                if (method.isAnnotationPresent(FreeReturnValue.class) || method.isAnnotationPresent(CallerOwnsReturn.class)) {
                    GlibAPI.GLIB_API.g_free(ptr);
                }
                return s;
            }
            return ((Pointer)result).getString(0L);
        }

        public Class<?> nativeType() {
            return Pointer.class;
        }

        public Object toNative(Object arg, ToNativeContext context) {
            return arg;
        }
    };
    private TypeConverter booleanConverter = new TypeConverter(){

        public Object toNative(Object arg, ToNativeContext context) {
            return Boolean.TRUE.equals(arg) ? 1 : 0;
        }

        public Object fromNative(Object arg0, FromNativeContext arg1) {
            return (Integer)arg0 != 0;
        }

        public Class<?> nativeType() {
            return Integer.class;
        }
    };
    private TypeConverter gquarkConverter = new TypeConverter(){

        public Object fromNative(Object arg0, FromNativeContext arg1) {
            return new GQuark((Integer)arg0);
        }

        public Class<?> nativeType() {
            return Integer.class;
        }

        public Object toNative(Object arg0, ToNativeContext arg1) {
            return ((GQuark)arg0).intValue();
        }
    };
    private TypeConverter intptrConverter = new TypeConverter(){

        public Object toNative(Object arg, ToNativeContext context) {
            return ((IntPtr)arg).value;
        }

        public Object fromNative(Object arg0, FromNativeContext arg1) {
            return new IntPtr(((Number)arg0).intValue());
        }

        public Class<?> nativeType() {
            return Pointer.SIZE == 8 ? Long.class : Integer.class;
        }
    };
    private TypeConverter querytypeConverter = new TypeConverter(){

        public Object toNative(Object arg, ToNativeContext context) {
            return ((QueryType)arg).intValue();
        }

        public Object fromNative(Object arg0, FromNativeContext arg1) {
            return QueryType.valueOf(((Number)arg0).intValue());
        }

        public Class<?> nativeType() {
            return Integer.class;
        }
    };
    private static ToNativeConverter uriConverter = new ToNativeConverter(){

        public Object toNative(Object arg0, ToNativeContext arg1) {
            URI uri = (URI)arg0;
            String uriString = uri.toString();
            if ("file".equals(uri.getScheme()) && uri.getHost() == null) {
                String path = uri.getRawPath();
                uriString = Platform.isWindows() ? "file:/" + path : "file://" + path;
            }
            return uriString;
        }

        public Class<?> nativeType() {
            return String.class;
        }
    };

    public GTypeMapper() {
        this.addTypeConverter(QueryType.class, this.querytypeConverter);
        this.addToNativeConverter(URI.class, uriConverter);
        this.addTypeConverter(ClockTime.class, clocktimeConverter);
    }

    public FromNativeConverter getFromNativeConverter(Class type) {
        if (Enum.class.isAssignableFrom(type)) {
            return enumConverter;
        }
        if (NativeObject.class.isAssignableFrom(type)) {
            return nativeObjectConverter;
        }
        if (Boolean.class == type || Boolean.TYPE == type) {
            return this.booleanConverter;
        }
        if (String.class == type) {
            return this.stringConverter;
        }
        if (IntPtr.class == type) {
            return this.intptrConverter;
        }
        if (GQuark.class == type) {
            return this.gquarkConverter;
        }
        return super.getFromNativeConverter(type);
    }

    public ToNativeConverter getToNativeConverter(Class type) {
        if (NativeObject.class.isAssignableFrom(type)) {
            return nativeObjectConverter;
        }
        if (NativeValue.class.isAssignableFrom(type)) {
            return nativeValueArgumentConverter;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return enumConverter;
        }
        if (Boolean.class == type || Boolean.TYPE == type) {
            return this.booleanConverter;
        }
        if (String.class == type) {
            return this.stringConverter;
        }
        if (IntPtr.class == type) {
            return this.intptrConverter;
        }
        if (GQuark.class == type) {
            return this.gquarkConverter;
        }
        return super.getToNativeConverter(type);
    }
}

