/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import org.gstreamer.Buffer;
import org.gstreamer.ClockTime;
import org.gstreamer.Element;
import org.gstreamer.FlowReturn;
import org.gstreamer.Format;
import org.gstreamer.Pad;
import org.gstreamer.lowlevel.BaseSrcAPI;
import org.gstreamer.lowlevel.GstAPI;
import org.gstreamer.lowlevel.NativeObject;

public class BaseSrc
extends Element {
    public static final String GTYPE_NAME = "GstBaseSrc";

    private static final BaseSrcAPI gst() {
        return BaseSrcAPI.BASESRC_API;
    }

    public BaseSrc(NativeObject.Initializer init) {
        super(init);
    }

    public FlowReturn waitPlaying() {
        return BaseSrc.gst().gst_base_src_wait_playing(this);
    }

    public void setLive(boolean live) {
        BaseSrc.gst().gst_base_src_set_live(this, live);
    }

    public boolean isLive() {
        return BaseSrc.gst().gst_base_src_is_live(this);
    }

    public void setFormat(Format format) {
        BaseSrc.gst().gst_base_src_set_format(this, format);
    }

    public boolean queryLatency(boolean[] live, ClockTime[] min_latency, ClockTime[] max_latency) {
        return BaseSrc.gst().gst_base_src_query_latency(this, live, min_latency, max_latency);
    }

    public void setBlocksize(long blocksize) {
        BaseSrc.gst().gst_base_src_set_blocksize(this, blocksize);
    }

    public long getBlocksize() {
        return BaseSrc.gst().gst_base_src_get_blocksize(this);
    }

    public void setTimestamp(boolean timestamp) {
        BaseSrc.gst().gst_base_src_set_do_timestamp(this, timestamp);
    }

    public boolean getTimestamp() {
        return BaseSrc.gst().gst_base_src_get_do_timestamp(this);
    }

    public boolean newSeamlessSegment(long start, long stop, long position) {
        return BaseSrc.gst().gst_base_src_new_seamless_segment(this, start, stop, position);
    }

    public void connect(final HANDOFF listener) {
        this.connect(HANDOFF.class, listener, new GstAPI.GstCallback(){

            public void callback(BaseSrc src, Buffer buffer, Pad pad) {
                listener.handoff(src, buffer, pad);
            }
        });
    }

    public void disconnect(HANDOFF listener) {
        this.disconnect(HANDOFF.class, listener);
    }

    public static interface HANDOFF {
        public void handoff(BaseSrc var1, Buffer var2, Pad var3);
    }
}

