/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.gstreamer.Bin;
import org.gstreamer.Bus;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.GhostPad;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.Pad;
import org.gstreamer.Pipeline;
import org.gstreamer.Structure;
import org.gstreamer.elements.DecodeBin2;
import org.gstreamer.swing.VideoComponent;

public class DecodeBinPlayer {
    static final String name = "DecodeBinPlayer";
    static JFrame frame;
    static VideoComponent videoComponent;
    static Pipeline pipe;

    public static void main(String[] args) {
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        args = Gst.init(name, args);
        if (args.length < 1) {
            System.err.println("Usage: DecodeBinPlayer <filename>");
            System.exit(1);
        }
        Element src = ElementFactory.make("filesrc", "Input File");
        src.set("location", args[0]);
        DecodeBin2 decodeBin = new DecodeBin2("Decode Bin");
        pipe = new Pipeline("main pipeline");
        Element decodeQueue = ElementFactory.make("queue", "Decode Queue");
        pipe.addMany(src, decodeQueue, decodeBin);
        Element.linkMany(src, decodeQueue, decodeBin);
        final Bin audioBin = new Bin("Audio Bin");
        Element conv = ElementFactory.make("audioconvert", "Audio Convert");
        Element resample = ElementFactory.make("audioresample", "Audio Resample");
        Element sink = ElementFactory.make("autoaudiosink", "sink");
        audioBin.addMany(conv, resample, sink);
        Element.linkMany(conv, resample, sink);
        audioBin.addPad(new GhostPad("sink", conv.getStaticPad("sink")));
        pipe.add(audioBin);
        decodeBin.connect(new Element.PAD_ADDED(){

            public void padAdded(Element element, Pad pad) {
                if (pad.isLinked()) {
                    return;
                }
                Caps caps = pad.getCaps();
                Structure struct = caps.getStructure(0);
                if (struct.getName().startsWith("audio/")) {
                    System.out.println("Linking audio pad: " + struct.getName());
                    pad.link(audioBin.getStaticPad("sink"));
                } else if (struct.getName().startsWith("video/")) {
                    System.out.println("Linking video pad: " + struct.getName());
                    pad.link(videoComponent.getElement().getStaticPad("sink"));
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            frame.setVisible(true);
                        }
                    });
                } else {
                    System.out.println("Unknown pad [" + struct.getName() + "]");
                }
            }
        });
        Bus bus = pipe.getBus();
        bus.connect(new Bus.ERROR(){

            public void errorMessage(GstObject source, int code, String message) {
                System.out.println("Error: code=" + code + " message=" + message);
            }
        });
        bus.connect(new Bus.EOS(){

            public void endOfStream(GstObject source) {
                pipe.stop();
                System.exit(0);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                frame = new JFrame("DecodeBin Player");
                videoComponent = new VideoComponent();
                videoComponent.setPreferredSize(new Dimension(640, 480));
                frame.add((Component)videoComponent, "Center");
                frame.setDefaultCloseOperation(3);
                frame.pack();
                frame.setVisible(false);
                pipe.add(videoComponent.getElement());
                pipe.play();
            }
        });
    }
}

