/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.lowlevel;

import com.sun.jna.Pointer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gstreamer.GObject;
import org.gstreamer.Gst;
import org.gstreamer.MiniObject;
import org.gstreamer.lowlevel.GstTypes;
import org.gstreamer.lowlevel.Handle;
import org.gstreamer.lowlevel.RefCountedObject;
import org.gstreamer.lowlevel.SubtypeMapper;
import org.gstreamer.lowlevel.annotations.HasSubtype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NativeObject
extends Handle {
    private static final Logger logger = Logger.getLogger(NativeObject.class.getName());
    private static final Level LIFECYCLE = Level.FINE;
    protected static final Initializer defaultInit = new Initializer();
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private final AtomicBoolean valid = new AtomicBoolean(true);
    private final Pointer handle;
    protected final AtomicBoolean ownsHandle = new AtomicBoolean(false);
    private final NativeRef nativeRef;

    protected static Initializer initializer(Pointer ptr) {
        return NativeObject.initializer(ptr, false, true);
    }

    protected static Initializer initializer(Pointer ptr, boolean needRef, boolean ownsHandle) {
        if (ptr == null) {
            throw new IllegalArgumentException("Invalid native pointer");
        }
        return new Initializer(ptr, needRef, ownsHandle);
    }

    protected NativeObject(Initializer init) {
        logger.entering("NativeObject", "<init>", new Object[]{init});
        if (init == null) {
            throw new IllegalArgumentException("Initializer cannot be null");
        }
        logger.log(LIFECYCLE, "Creating " + this.getClass().getSimpleName() + " (" + init.ptr + ")");
        this.nativeRef = new NativeRef(this);
        this.handle = init.ptr;
        this.ownsHandle.set(init.ownsHandle);
        if (GObject.class.isAssignableFrom(this.getClass())) {
            NativeObject.getInstanceMap().put(init.ptr, this.nativeRef);
        }
    }

    protected abstract void disposeNativeHandle(Pointer var1);

    public void dispose() {
        logger.log(LIFECYCLE, "Disposing object " + this.getClass().getName() + " = " + this.handle);
        if (!this.disposed.getAndSet(true)) {
            NativeObject.getInstanceMap().remove(this.handle, this.nativeRef);
            if (this.ownsHandle.get()) {
                this.disposeNativeHandle(this.handle);
            }
            this.valid.set(false);
        }
    }

    @Override
    protected void invalidate() {
        logger.log(LIFECYCLE, "Invalidating object " + this + " = " + this.handle());
        NativeObject.getInstanceMap().remove(this.handle(), this.nativeRef);
        this.disposed.set(true);
        this.ownsHandle.set(false);
        this.valid.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            logger.log(LIFECYCLE, "Finalizing " + this.getClass().getSimpleName() + " (" + this.handle + ")");
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    protected Object nativeValue() {
        return this.handle();
    }

    protected Pointer handle() {
        if (!this.valid.get()) {
            throw new IllegalStateException("Native object has been disposed");
        }
        return this.handle;
    }

    public Pointer getNativeAddress() {
        return this.handle;
    }

    protected boolean isDisposed() {
        return this.disposed.get();
    }

    protected static NativeObject instanceFor(Pointer ptr) {
        WeakReference ref = (WeakReference)NativeObject.getInstanceMap().get(ptr);
        if (ref != null && ref.get() == null) {
            NativeObject.getInstanceMap().remove(ptr);
        }
        return ref != null ? (NativeObject)ref.get() : null;
    }

    public static <T extends NativeObject> T objectFor(Pointer ptr, Class<T> cls) {
        return NativeObject.objectFor(ptr, cls, true);
    }

    public static <T extends NativeObject> T objectFor(Pointer ptr, Class<T> cls, boolean needRef) {
        return NativeObject.objectFor(ptr, cls, needRef, true);
    }

    public static <T extends NativeObject> T objectFor(Pointer ptr, Class<T> cls, boolean needRef, boolean ownsHandle) {
        return NativeObject.objectFor(ptr, cls, needRef ? 1 : 0, ownsHandle);
    }

    public static <T extends NativeObject> T objectFor(Pointer ptr, Class<T> cls, int refAdjust, boolean ownsHandle) {
        NativeObject obj;
        logger.entering("NativeObject", "instanceFor", new Object[]{ptr, refAdjust, ownsHandle});
        if (ptr == null) {
            return null;
        }
        NativeObject nativeObject = obj = GObject.class.isAssignableFrom(cls) ? NativeObject.instanceFor(ptr) : null;
        if (obj != null && cls.isInstance(obj)) {
            if (refAdjust < 0) {
                ((RefCountedObject)obj).unref();
            }
            return (T)((NativeObject)cls.cast(obj));
        }
        if (GObject.class.isAssignableFrom(cls) || MiniObject.class.isAssignableFrom(cls)) {
            cls = NativeObject.classFor(ptr, cls);
        }
        try {
            Constructor<T> constructor = cls.getDeclaredConstructor(Initializer.class);
            NativeObject retVal = (NativeObject)constructor.newInstance(NativeObject.initializer(ptr, refAdjust > 0, ownsHandle));
            return (T)retVal;
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static <T extends NativeObject> Class<T> classFor(Pointer ptr, Class<T> defaultClass) {
        Class<NativeObject> cls = GstTypes.classFor(ptr);
        if (cls != null && cls.isAnnotationPresent(HasSubtype.class)) {
            cls = SubtypeMapper.subtypeFor(cls, ptr);
        }
        return cls != null && defaultClass.isAssignableFrom(cls) ? cls : defaultClass;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof NativeObject && ((NativeObject)o).handle.equals((Object)this.handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.handle() + ")";
    }

    public void disown() {
        logger.log(LIFECYCLE, "Disowning " + this.handle());
        this.ownsHandle.set(false);
    }

    private static final void shutdown() {
        Gst.addStaticShutdownTask(new Runnable(){

            public void run() {
                System.gc();
                int gcCount = 20;
                while (!NativeObject.getInstanceMap().isEmpty() && gcCount-- > 0) {
                    try {
                        Thread.sleep(10L);
                        System.gc();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
                for (Object o : NativeObject.getInstanceMap().values().toArray()) {
                    NativeObject obj = (NativeObject)((NativeRef)o).get();
                    if (obj == null || obj.disposed.get()) continue;
                    obj.dispose();
                }
            }
        });
    }

    private static final ConcurrentMap<Pointer, NativeRef> getInstanceMap() {
        return StaticData.instanceMap;
    }

    static {
        NativeObject.shutdown();
    }

    private static final class StaticData {
        private static final ConcurrentMap<Pointer, NativeRef> instanceMap = new ConcurrentHashMap<Pointer, NativeRef>();

        private StaticData() {
        }

        static {
            NativeObject.shutdown();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NativeRef
    extends WeakReference<NativeObject> {
        public NativeRef(NativeObject obj) {
            super(obj);
        }
    }

    protected static class Initializer {
        public final Pointer ptr;
        public final boolean needRef;
        public final boolean ownsHandle;

        public Initializer() {
            this.ptr = null;
            this.needRef = false;
            this.ownsHandle = false;
        }

        public Initializer(Pointer ptr, boolean needRef, boolean ownsHandle) {
            this.ptr = ptr;
            this.needRef = needRef;
            this.ownsHandle = ownsHandle;
        }
    }
}

