/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.swing;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gstreamer.elements.PlayBin2;

public class PopupVolumeButton
extends JToggleButton {
    private static final long serialVersionUID = 3957280083515502726L;
    private JPanel volumePanel;
    private JSlider volumeSlider;
    private ImageIcon lowVolumeIcon = PopupVolumeButton.loadIcon("status/audio-volume-low");
    private ImageIcon medVolumeIcon = PopupVolumeButton.loadIcon("status/audio-volume-medium");
    private ImageIcon highVolumeIcon = PopupVolumeButton.loadIcon("status/audio-volume-high");
    private ChangeListener volumeChanged = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            JSlider s = (JSlider)e.getSource();
            if (s.getValue() < 33) {
                PopupVolumeButton.this.volumeAction.putValue("SmallIcon", PopupVolumeButton.this.lowVolumeIcon);
            } else if (s.getValue() < 66) {
                PopupVolumeButton.this.volumeAction.putValue("SmallIcon", PopupVolumeButton.this.medVolumeIcon);
            } else {
                PopupVolumeButton.this.volumeAction.putValue("SmallIcon", PopupVolumeButton.this.highVolumeIcon);
            }
        }
    };
    Popup volumePopup;
    private AbstractAction volumeAction = new AbstractAction("", PopupVolumeButton.loadIcon("status/audio-volume-medium")){
        private static final long serialVersionUID = 3977109421439093963L;

        public void actionPerformed(ActionEvent e) {
            JToggleButton b = (JToggleButton)e.getSource();
            if (!b.isSelected() && PopupVolumeButton.this.volumePopup != null) {
                PopupVolumeButton.this.volumePopup.hide();
                PopupVolumeButton.this.volumePopup = null;
            } else {
                Dimension panelSize = PopupVolumeButton.this.volumePanel.getPreferredSize();
                Point location = new Point(0 - panelSize.width + PopupVolumeButton.this.getPreferredSize().width, 0 - panelSize.height);
                SwingUtilities.convertPointToScreen(location, PopupVolumeButton.this);
                PopupVolumeButton.this.volumePopup = PopupFactory.getSharedInstance().getPopup(PopupVolumeButton.this, PopupVolumeButton.this.volumePanel, location.x, location.y);
                Object paintValue = UIManager.put("Slider.paintValue", Boolean.FALSE);
                PopupVolumeButton.this.volumePopup.show();
                UIManager.put("Slider.paintValue", paintValue);
            }
        }
    };

    public PopupVolumeButton(BoundedRangeModel model) {
        this.volumePanel = new JPanel();
        this.volumePanel.setLayout(new BoxLayout(this.volumePanel, 1));
        this.volumeSlider = new JSlider(model);
        this.volumeSlider.addChangeListener(this.volumeChanged);
        this.volumeSlider.setOrientation(1);
        this.volumePanel.add(new JLabel(this.highVolumeIcon));
        this.volumeSlider.setAlignmentX(0.25f);
        this.volumePanel.add(this.volumeSlider);
        this.volumePanel.add(new JLabel(this.lowVolumeIcon));
        this.volumePanel.validate();
        this.setAction(this.volumeAction);
    }

    public PopupVolumeButton(final PlayBin2 playbin) {
        this(new DefaultBoundedRangeModel(){
            private static final long serialVersionUID = 1462054216375236024L;

            public int getMaximum() {
                return 100;
            }

            public int getMinimum() {
                return 0;
            }

            public int getValue() {
                return (int)(playbin.getVolume() * 100.0 + 0.5);
            }

            public void setValue(int percent) {
                playbin.setVolume(Math.max(Math.min((double)percent, 100.0), 0.0) / 100.0);
            }
        });
    }

    private static ImageIcon loadIcon(String name) {
        return PopupVolumeButton.loadIcon(16, name);
    }

    private static ImageIcon loadIcon(int size, String name) {
        String path = "/org/freedesktop/tango/" + size + "x" + size + "/" + name + ".png";
        URL url = PopupVolumeButton.class.getResource(path);
        if (url != null) {
            return new ImageIcon(url);
        }
        throw new RuntimeException("Cannot locate icon for " + name);
    }
}

