/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import com.sun.jna.Pointer;
import java.util.concurrent.TimeUnit;
import org.gstreamer.Bin;
import org.gstreamer.Bus;
import org.gstreamer.Clock;
import org.gstreamer.ClockTime;
import org.gstreamer.Format;
import org.gstreamer.GError;
import org.gstreamer.GstException;
import org.gstreamer.Query;
import org.gstreamer.SeekType;
import org.gstreamer.Segment;
import org.gstreamer.lowlevel.GstAPI;
import org.gstreamer.lowlevel.GstElementAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.GstParseAPI;
import org.gstreamer.lowlevel.GstPipelineAPI;
import org.gstreamer.lowlevel.GstQueryAPI;
import org.gstreamer.lowlevel.NativeObject;
import org.gstreamer.lowlevel.annotations.CallerOwnsReturn;

public class Pipeline
extends Bin {
    public static final String GST_NAME = "pipeline";
    public static final String GTYPE_NAME = "GstPipeline";
    private static final API gst = GstNative.load(API.class);

    public Pipeline(NativeObject.Initializer init) {
        super(init);
    }

    public Pipeline() {
        this(Pipeline.initializer(gst.ptr_gst_pipeline_new(null)));
        this.initBus();
    }

    public Pipeline(String name) {
        this(Pipeline.initializer(gst.ptr_gst_pipeline_new(name)));
        this.initBus();
    }

    public static Pipeline launch(String pipelineDecription) {
        Pointer[] err = new Pointer[]{null};
        Pipeline pipeline = gst.gst_parse_launch(pipelineDecription, err);
        if (pipeline == null) {
            throw new GstException(new GError(new GstAPI.GErrorStruct(err[0])));
        }
        pipeline.initBus();
        return pipeline;
    }

    public static Pipeline launch(String ... pipelineDecription) {
        Pointer[] err = new Pointer[]{null};
        Pipeline pipeline = gst.gst_parse_launchv(pipelineDecription, err);
        if (pipeline == null) {
            throw new GstException(new GError(new GstAPI.GErrorStruct(err[0])));
        }
        pipeline.initBus();
        return pipeline;
    }

    private void initBus() {
        Bus bus = this.getBus();
        bus.setFlushing(true);
        bus.setFlushing(false);
    }

    public void setAutoFlushBus(boolean flush) {
        gst.gst_pipeline_set_auto_flush_bus(this, flush);
    }

    public boolean getAutoFlushBus() {
        return gst.gst_pipeline_get_auto_flush_bus(this);
    }

    public boolean setClock(Clock clock) {
        return gst.gst_pipeline_set_clock(this, clock);
    }

    public Clock getClock() {
        return gst.gst_pipeline_get_clock(this);
    }

    public void useClock(Clock clock) {
        gst.gst_pipeline_use_clock(this, clock);
    }

    public Bus getBus() {
        return gst.gst_pipeline_get_bus(this);
    }

    public boolean seek(ClockTime time) {
        return this.seek(time.convertTo(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
    }

    public boolean seek(long time, TimeUnit unit) {
        return this.seek(1.0, Format.TIME, 5, SeekType.SET, TimeUnit.NANOSECONDS.convert(time, unit), SeekType.NONE, -1L);
    }

    public boolean seek(double rate, Format format, int flags, SeekType startType, long start, SeekType stopType, long stop) {
        return gst.gst_element_seek(this, rate, format, flags, startType, start, stopType, stop);
    }

    public ClockTime queryPosition() {
        return ClockTime.valueOf(this.queryPosition(Format.TIME), TimeUnit.NANOSECONDS);
    }

    public long queryPosition(TimeUnit unit) {
        return unit.convert(this.queryPosition(Format.TIME), TimeUnit.NANOSECONDS);
    }

    public long queryPosition(Format format) {
        Format[] fmt = new Format[]{format};
        long[] pos = new long[]{0L};
        return gst.gst_element_query_position(this, fmt, pos) ? pos[0] : -1L;
    }

    public ClockTime queryDuration() {
        return ClockTime.valueOf(this.queryDuration(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
    }

    public long queryDuration(TimeUnit unit) {
        Format[] fmt = new Format[]{Format.TIME};
        long[] duration = new long[]{0L};
        gst.gst_element_query_duration(this, fmt, duration);
        return unit.convert(duration[0], TimeUnit.NANOSECONDS);
    }

    public long queryDuration(Format format) {
        Format[] fmt = new Format[]{format};
        long[] duration = new long[]{0L};
        gst.gst_element_query_duration(this, fmt, duration);
        return duration[0];
    }

    public Segment querySegment() {
        return this.querySegment(Format.TIME);
    }

    public Segment querySegment(Format format) {
        Query qry = GstQueryAPI.GSTQUERY_API.gst_query_new_segment(format);
        gst.gst_element_query(this, qry);
        double[] rate = new double[]{0.0};
        Format[] fmt = new Format[]{Format.UNDEFINED};
        long[] start_value = new long[]{0L};
        long[] stop_value = new long[]{0L};
        GstQueryAPI.GSTQUERY_API.gst_query_parse_segment(qry, rate, fmt, start_value, stop_value);
        return new Segment(rate[0], fmt[0], start_value[0], stop_value[0]);
    }

    private static interface API
    extends GstElementAPI,
    GstPipelineAPI,
    GstParseAPI {
        @CallerOwnsReturn
        public Pointer ptr_gst_pipeline_new(String var1);
    }
}

