/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.gstreamer.Buffer;
import org.gstreamer.Bus;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.Pad;
import org.gstreamer.TagList;
import org.gstreamer.elements.BaseSink;
import org.gstreamer.elements.FakeSink;
import org.gstreamer.elements.PlayBin2;

public class TagFinder {
    private static final String progname = "TagFinder";

    public static void main(String[] args) {
        final CountDownLatch done = new CountDownLatch(1);
        if ((args = Gst.init(progname, args)).length < 0) {
            System.out.println("Usage: TagFinder <filename>");
            System.exit(1);
        }
        final PlayBin2 pipe = new PlayBin2(progname);
        pipe.setInputFile(new File(args[0]));
        FakeSink audio = (FakeSink)ElementFactory.make("fakesink", "audio-sink");
        FakeSink video = (FakeSink)ElementFactory.make("fakesink", "video-sink");
        pipe.setAudioSink(audio);
        pipe.setVideoSink(video);
        pipe.getBus().connect(new Bus.TAG(){

            public void tagsFound(GstObject source, TagList tagList) {
                for (String tag : tagList.getTagNames()) {
                    System.out.println("Found tag " + tag + " = " + tagList.getValue(tag, 0));
                }
            }
        });
        pipe.getBus().connect(new Bus.ASYNC_DONE(){

            public void asyncDone(GstObject source) {
                pipe.stop();
                done.countDown();
            }
        });
        audio.set("signal-handoffs", true);
        video.set("signal-handoffs", true);
        BaseSink.HANDOFF handoff = new BaseSink.HANDOFF(){

            public void handoff(BaseSink sink, Buffer buffer, Pad pad) {
                pipe.stop();
                done.countDown();
            }
        };
        audio.connect(handoff);
        video.connect(handoff);
        pipe.pause();
        try {
            done.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        pipe.stop();
    }
}

