/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingExecutorService
extends AbstractExecutorService
implements ScheduledExecutorService {
    private final AtomicBoolean isShutDown = new AtomicBoolean(false);

    public <T> T wrap(Class<T> interfaceClass, T instance) {
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new ExecutorInvocationProxy(instance, this)));
    }

    @Override
    public void shutdown() {
        this.isShutDown.set(true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutDown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit units) throws InterruptedException {
        return false;
    }

    @Override
    public void execute(Runnable task) {
        SwingUtilities.invokeLater(task);
    }

    private <V> ScheduledFuture<V> schedule(Callable<V> callable, long initialDelay, long interval, TimeUnit units) {
        SwingFuture<V> f = new SwingFuture<V>(callable, initialDelay, interval, units);
        ((SwingFuture)f).timer.start();
        return f;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, long initialDelay, TimeUnit units) {
        return this.schedule(Executors.callable(task), initialDelay, 0L, units);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> task, long initialDelay, TimeUnit units) {
        return this.schedule(task, initialDelay, 0L, units);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long interval, TimeUnit units) {
        return this.schedule(Executors.callable(task), initialDelay, interval, units);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long interval, TimeUnit units) {
        return this.schedule(Executors.callable(task), initialDelay, interval, units);
    }

    private static class ExecutorInvocationProxy
    implements InvocationHandler {
        private final Executor executor;
        private final Object object;

        public ExecutorInvocationProxy(Object object, Executor executor) {
            this.object = object;
            this.executor = executor;
        }

        public Object invoke(Object self, final Method method, final Object[] argArray) throws Throwable {
            if (method.getName().equals("hashCode")) {
                return this.object.hashCode();
            }
            if (method.getName().equals("equals")) {
                return this.object.equals(argArray[0]);
            }
            this.executor.execute(new Runnable(){

                public void run() {
                    try {
                        method.invoke(ExecutorInvocationProxy.this.object, argArray);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SwingFuture<V>
    extends FutureTask<V>
    implements ScheduledFuture<V>,
    ActionListener {
        private final Timer timer = new Timer(1, this);

        SwingFuture(Callable<V> call, long initialDelay, long interval, TimeUnit unit) {
            super(call);
            this.timer.setInitialDelay(Math.max(1, (int)unit.toMillis(initialDelay)));
            this.timer.setDelay(Math.max(1, (int)unit.toMillis(interval)));
            this.timer.setCoalesce(false);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.timer.getDelay(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            Long lhs = this.getDelay(TimeUnit.NANOSECONDS);
            Long rhs = delayed.getDelay(TimeUnit.NANOSECONDS);
            return lhs.compareTo(rhs);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (this.timer.getDelay() != 0) {
                this.runAndReset();
            } else {
                this.run();
            }
        }
    }
}

