/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Fraction;
import org.gstreamer.Pad;
import org.gstreamer.Pipeline;
import org.gstreamer.Structure;
import org.gstreamer.elements.BufferDataAppSink;
import org.gstreamer.elements.RGBDataAppSink;
import org.gstreamer.interfaces.Property;
import org.gstreamer.interfaces.PropertyProbe;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.video.Video;

public class Capture
extends PImage
implements PConstants {
    protected static String sourceElementName;
    protected static String devicePropertyName;
    protected static String indexPropertyName;
    protected static boolean useResMacHack;
    public float frameRate;
    public Pipeline pipeline;
    protected boolean capturing = false;
    protected String frameRateString;
    protected int bufWidth;
    protected int bufHeight;
    protected String sourceName;
    protected Element sourceElement;
    protected Method captureEventMethod;
    protected Object eventHandler;
    protected boolean available;
    protected boolean pipelineReady;
    protected boolean newFrame;
    protected RGBDataAppSink rgbSink = null;
    protected int[] copyPixels = null;
    protected boolean firstFrame = true;
    protected int reqWidth;
    protected int reqHeight;
    protected boolean useBufferSink = false;
    protected boolean outdatedPixels = true;
    protected Object bufferSink;
    protected Method sinkCopyMethod;
    protected Method sinkSetMethod;
    protected Method sinkDisposeMethod;
    protected Method sinkGetMethod;
    protected String copyMask;
    protected Buffer natBuffer = null;
    protected BufferDataAppSink natSink = null;

    public Capture(PApplet pApplet) {
        Object object;
        String string;
        String[] stringArray = Capture.list();
        if (stringArray.length == 0) {
            throw new RuntimeException("There are no cameras available for capture");
        }
        String string2 = this.getName(stringArray[0]);
        int[] nArray = this.getSize(stringArray[0]);
        String string3 = this.getFrameRate(stringArray[0]);
        if (devicePropertyName.equals("")) {
            string = indexPropertyName;
            object = new Integer(PApplet.parseInt((String)string2));
        } else {
            string = devicePropertyName;
            object = string2;
        }
        this.initGStreamer(pApplet, nArray[0], nArray[1], sourceElementName, string, object, string3);
    }

    public Capture(PApplet pApplet, String string) {
        Object object;
        String string2;
        String string3 = this.getName(string);
        int[] nArray = this.getSize(string);
        String string4 = this.getFrameRate(string);
        if (devicePropertyName.equals("")) {
            string2 = indexPropertyName;
            object = new Integer(PApplet.parseInt((String)string3));
        } else {
            string2 = devicePropertyName;
            object = string3;
        }
        this.initGStreamer(pApplet, nArray[0], nArray[1], sourceElementName, string2, object, string4);
    }

    public Capture(PApplet pApplet, int n, int n2) {
        super(n, n2, 1);
        this.initGStreamer(pApplet, n, n2, sourceElementName, null, null, "");
    }

    public Capture(PApplet pApplet, int n, int n2, int n3) {
        super(n, n2, 1);
        this.initGStreamer(pApplet, n, n2, sourceElementName, null, null, n3 + "/1");
    }

    public Capture(PApplet pApplet, int n, int n2, String string) {
        super(n, n2, 1);
        Object object;
        String string2;
        if (-1 < string.indexOf("name=")) {
            string = this.getName(string);
        }
        if (devicePropertyName.equals("")) {
            string2 = indexPropertyName;
            object = new Integer(PApplet.parseInt((String)string));
        } else {
            string2 = devicePropertyName;
            object = string;
        }
        this.initGStreamer(pApplet, n, n2, sourceElementName, string2, object, "");
    }

    public Capture(PApplet pApplet, int n, int n2, String string, int n3) {
        super(n, n2, 1);
        Object object;
        String string2;
        if (-1 < string.indexOf("name=")) {
            string = this.getName(string);
        }
        if (devicePropertyName.equals("")) {
            string2 = indexPropertyName;
            object = new Integer(PApplet.parseInt((String)string));
        } else {
            string2 = devicePropertyName;
            object = string;
        }
        this.initGStreamer(pApplet, n, n2, sourceElementName, string2, object, n3 + "/1");
    }

    public void dispose() {
        if (this.pipeline != null) {
            try {
                if (this.pipeline.isPlaying()) {
                    this.pipeline.stop();
                    this.pipeline.getState();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.pixels = null;
            this.copyPixels = null;
            if (this.rgbSink != null) {
                this.rgbSink.removeListener();
                this.rgbSink.dispose();
                this.rgbSink = null;
            }
            this.natBuffer = null;
            if (this.natSink != null) {
                this.natSink.removeListener();
                this.natSink.dispose();
                this.natSink = null;
            }
            this.pipeline.dispose();
            this.pipeline = null;
            this.parent.g.removeCache((PImage)this);
            this.parent.unregisterMethod("dispose", (Object)this);
            this.parent.unregisterMethod("post", (Object)this);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public boolean available() {
        return this.available;
    }

    public void start() {
        boolean bl = false;
        if (!this.pipelineReady) {
            this.initPipeline();
            bl = true;
        }
        this.capturing = true;
        this.pipeline.play();
        if (bl) {
            this.checkResIsValid();
        }
    }

    public void stop() {
        if (!this.pipelineReady) {
            this.initPipeline();
        }
        this.capturing = false;
        this.pipeline.stop();
        this.pipeline.getState();
    }

    public synchronized void read() {
        if (this.frameRate < 0.0f) {
            this.frameRate = this.getSourceFrameRate();
        }
        if (this.useBufferSink) {
            Object object;
            this.outdatedPixels = true;
            if (this.natBuffer == null) {
                return;
            }
            if (this.firstFrame) {
                super.init(this.bufWidth, this.bufHeight, 2, 1);
                this.firstFrame = false;
            }
            if (this.bufferSink == null) {
                object = this.parent.g.getCache((PImage)this);
                if (object == null) {
                    return;
                }
                this.setBufferSink(object);
                this.getSinkMethods();
            }
            object = this.natBuffer.getByteBuffer();
            try {
                this.sinkCopyMethod.invoke(this.bufferSink, this.natBuffer, object, this.bufWidth, this.bufHeight);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.natBuffer = null;
        } else {
            if (this.copyPixels == null) {
                return;
            }
            if (this.firstFrame) {
                super.init(this.bufWidth, this.bufHeight, 1, 1);
                this.firstFrame = false;
            }
            int[] nArray = this.pixels;
            this.pixels = this.copyPixels;
            this.updatePixels();
            this.copyPixels = nArray;
        }
        this.available = false;
        this.newFrame = true;
    }

    public synchronized void loadPixels() {
        super.loadPixels();
        if (this.useBufferSink) {
            if (this.natBuffer != null) {
                IntBuffer intBuffer = this.natBuffer.getByteBuffer().asIntBuffer();
                intBuffer.rewind();
                intBuffer.get(this.pixels);
                Video.convertToARGB(this.pixels, this.width, this.height);
            } else if (this.sinkGetMethod != null) {
                try {
                    this.sinkGetMethod.invoke(this.bufferSink, new Object[]{this.pixels});
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.outdatedPixels = false;
        }
    }

    public int get(int n, int n2) {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        return super.get(n, n2);
    }

    protected void getImpl(int n, int n2, int n3, int n4, PImage pImage, int n5, int n6) {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        super.getImpl(n, n2, n3, n4, pImage, n5, n6);
    }

    public static String[] list() {
        if (devicePropertyName.equals("")) {
            return Capture.list(sourceElementName, indexPropertyName);
        }
        return Capture.list(sourceElementName, devicePropertyName);
    }

    protected static String[] list(String string, String string2) {
        Video.init();
        ArrayList<String> arrayList = Capture.listDevices(string, string2);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string3 : arrayList) {
            ArrayList<String> arrayList3 = Capture.listResolutions(string, string2, string3);
            if (0 < arrayList3.size()) {
                for (String string4 : arrayList3) {
                    arrayList2.add("name=" + string3 + "," + string4);
                }
                continue;
            }
            arrayList2.add("name=" + string3);
        }
        String[] stringArray = new String[arrayList2.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList2.get(i);
        }
        return stringArray;
    }

    protected static ArrayList<String> listDevices(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Object[] objectArray;
            Property property;
            Element element = ElementFactory.make((String)string, (String)"Source");
            PropertyProbe propertyProbe = PropertyProbe.wrap((Element)element);
            if (propertyProbe != null && (property = propertyProbe.getProperty(string2)) != null && (objectArray = propertyProbe.getValues(property)) != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] instanceof String) {
                        arrayList.add((String)objectArray[i]);
                        continue;
                    }
                    if (!(objectArray[i] instanceof Integer)) continue;
                    arrayList.add(((Integer)objectArray[i]).toString());
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (PApplet.platform == 3) {
                arrayList = new ArrayList();
                String string3 = "/dev";
                File file = new File(string3);
                String[] stringArray = file.list();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (-1 >= stringArray[i].indexOf("video")) continue;
                        arrayList.add("/dev/" + stringArray[i]);
                    }
                }
            }
            PGraphics.showWarning((String)"The capture plugin does not support device query!");
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    protected static ArrayList<String> listResolutions(String string, String string2, Object object) {
        Pipeline pipeline = new Pipeline("test");
        Element element = ElementFactory.make((String)string, (String)"source");
        element.set(string2, object);
        BufferDataAppSink bufferDataAppSink = new BufferDataAppSink("sink", "", new BufferDataAppSink.Listener(){

            public void bufferFrame(int n, int n2, Buffer buffer) {
            }
        });
        pipeline.addMany(new Element[]{element, bufferDataAppSink});
        Element.linkMany((Element[])new Element[]{element, bufferDataAppSink});
        pipeline.play();
        pipeline.getState();
        pipeline.pause();
        pipeline.getState();
        ArrayList<String> arrayList = new ArrayList<String>();
        Capture.addResFromSource(arrayList, element);
        pipeline.stop();
        pipeline.getState();
        if (bufferDataAppSink != null) {
            bufferDataAppSink.removeListener();
            bufferDataAppSink.dispose();
        }
        pipeline.dispose();
        return arrayList;
    }

    protected static void addResFromSource(ArrayList<String> arrayList, Element element) {
        if (PApplet.platform == 2 && useResMacHack) {
            Capture.addResFromSourceMacHack(arrayList, element);
        } else {
            Capture.addResFromSourceImpl(arrayList, element);
        }
    }

    protected static void addResFromSourceImpl(ArrayList<String> arrayList, Element element) {
        for (Pad pad : element.getPads()) {
            Caps caps = pad.getCaps();
            int n = caps.size();
            for (int i = 0; i < n; ++i) {
                Structure structure = caps.getStructure(i);
                if (!structure.hasIntField("width") || !structure.hasIntField("height")) continue;
                int n2 = (Integer)structure.getValue("width");
                int n3 = (Integer)structure.getValue("height");
                if (PApplet.platform == 1) {
                    Capture.addResFromString(arrayList, structure.toString(), n2, n3);
                    continue;
                }
                Capture.addResFromStructure(arrayList, structure, n2, n3);
            }
        }
    }

    protected static void addResFromSourceMacHack(ArrayList<String> arrayList, Element element) {
        block2: for (Pad pad : element.getPads()) {
            Caps caps = pad.getNegotiatedCaps();
            int n = caps.size();
            if (0 >= n) continue;
            Structure structure = caps.getStructure(0);
            if (!structure.hasIntField("width") || !structure.hasIntField("height")) {
                return;
            }
            int n2 = (Integer)structure.getValue("width");
            int n3 = (Integer)structure.getValue("height");
            while (80 <= n2) {
                int n4 = 30;
                int n5 = 1;
                try {
                    Fraction fraction = structure.getFraction("framerate");
                    n4 = fraction.numerator;
                    n5 = fraction.denominator;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                arrayList.add(Capture.makeResolutionString(n2, n3, n4, n5));
                if (n4 == 30 && n5 == 1) {
                    arrayList.add(Capture.makeResolutionString(n2, n3, 15, 1));
                    arrayList.add(Capture.makeResolutionString(n2, n3, 1, 1));
                }
                if (n2 % 2 != 0 || n3 % 2 != 0) continue block2;
                n2 /= 2;
                n3 /= 2;
            }
        }
    }

    protected static void addResFromString(ArrayList<String> arrayList, String string, int n, int n2) {
        int n3 = string.indexOf("framerate=(fraction)");
        if (-1 < n3) {
            String string2 = string.substring(n3 + 20, string.length());
            int n4 = string2.indexOf("[");
            int n5 = string2.indexOf("]");
            if (-1 < n4 && -1 < n5) {
                string2 = string2.substring(n4 + 1, n5);
                String[] stringArray = string2.split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i].trim();
                    arrayList.add(Capture.makeResolutionString(n, n2, string3));
                }
            } else {
                int n6 = string2.indexOf(",");
                int n7 = string2.indexOf(";");
                if (-1 < n6 || -1 < n7) {
                    int n8 = -1;
                    n8 = n6 == -1 ? n7 : (n7 == -1 ? n6 : PApplet.min((int)n6, (int)n7));
                    string2 = string2.substring(0, n8);
                    String string4 = string2.trim();
                    arrayList.add(Capture.makeResolutionString(n, n2, string4));
                }
            }
        }
    }

    protected static void addResFromStructure(ArrayList<String> arrayList, Structure structure, int n, int n2) {
        Fraction fraction;
        boolean bl = false;
        try {
            fraction = structure.getFraction("framerate");
            arrayList.add(Capture.makeResolutionString(n, n2, fraction.numerator, fraction.denominator));
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            fraction = null;
            try {
                fraction = structure.getValueList("framerate");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fraction != null) {
                for (int i = 0; i < fraction.getSize(); ++i) {
                    Fraction fraction2 = fraction.getFraction(i);
                    arrayList.add(Capture.makeResolutionString(n, n2, fraction2.numerator, fraction2.denominator));
                }
            }
        }
    }

    protected static String makeResolutionString(int n, int n2, int n3, int n4) {
        String string = "size=" + n + "x" + n2 + ",fps=" + n3;
        if (n4 != 1) {
            string = string + "/" + n4;
        }
        return string;
    }

    protected static String makeResolutionString(int n, int n2, String string) {
        String string2 = "size=" + n + "x" + n2;
        String[] stringArray = string.split("/");
        if (stringArray.length == 2) {
            int n3 = PApplet.parseInt((String)stringArray[0]);
            int n4 = PApplet.parseInt((String)stringArray[1]);
            string2 = string2 + ",fps=" + n3;
            if (n4 != 1) {
                string2 = string2 + "/" + n4;
            }
        }
        return string2;
    }

    protected void checkResIsValid() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Capture.addResFromSource(arrayList, this.sourceElement);
        boolean bl = arrayList.size() == 0;
        for (String string : arrayList) {
            if (!this.validRes(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            Object object = "";
            if (!this.frameRateString.equals("")) {
                object = ", " + this.frameRateString + "fps";
            }
            throw new RuntimeException("The requested resolution of " + this.reqWidth + "x" + this.reqHeight + (String)object + " is not supported by the selected capture " + "device.\n");
        }
    }

    protected void checkValidDevices(String string) {
        ArrayList<String> arrayList = devicePropertyName.equals("") ? Capture.listDevices(string, indexPropertyName) : Capture.listDevices(string, devicePropertyName);
        if (arrayList.size() == 0) {
            throw new RuntimeException("There are no capture devices connected to this computer.\n");
        }
    }

    protected boolean validRes(String string) {
        int[] nArray = this.getSize(string);
        String string2 = this.getFrameRate(string);
        return (this.reqWidth == 0 || this.reqHeight == 0 || nArray[0] == this.reqWidth && nArray[1] == this.reqHeight) && (this.frameRateString.equals("") || this.frameRateString.equals(string2));
    }

    protected void initGStreamer(PApplet pApplet, int n, int n2, String string, String string2, Object object, String string3) {
        this.parent = pApplet;
        Video.init();
        this.checkValidDevices(string);
        pApplet.registerMethod("dispose", (Object)this);
        pApplet.registerMethod("post", (Object)this);
        this.setEventHandlerObject(pApplet);
        this.pipeline = new Pipeline("Video Capture");
        this.frameRateString = string3;
        if (this.frameRateString.equals("")) {
            this.frameRate = -1.0f;
        } else {
            String[] stringArray = this.frameRateString.split("/");
            if (stringArray.length == 2) {
                int n3 = PApplet.parseInt((String)stringArray[0]);
                int n4 = PApplet.parseInt((String)stringArray[1]);
                this.frameRate = (float)n3 / (float)n4;
            } else if (stringArray.length == 1) {
                this.frameRateString = this.frameRateString + "/1";
                this.frameRate = PApplet.parseFloat((String)stringArray[0]);
            } else {
                this.frameRateString = "";
                this.frameRate = -1.0f;
            }
        }
        this.reqWidth = n;
        this.reqHeight = n2;
        this.sourceName = string;
        this.sourceElement = ElementFactory.make((String)string, (String)"Source");
        if (string2 != null && !string2.equals("")) {
            this.sourceElement.set(string2, object);
        }
        this.bufHeight = 0;
        this.bufWidth = 0;
        this.pipelineReady = false;
    }

    protected void initPipeline() {
        String string = "";
        if (0 < this.reqWidth && 0 < this.reqHeight) {
            string = "width=" + this.reqWidth + ", height=" + this.reqHeight;
        } else {
            PGraphics.showWarning((String)"Resolution information not available, attempting to open the capture device at 320x240");
            string = "width=320, height=240";
        }
        String string2 = "";
        if (!this.frameRateString.equals("")) {
            string2 = ", framerate=" + this.frameRateString;
        }
        if (this.bufferSink != null || Video.useGLBufferSink && this.parent.g.isGL()) {
            this.useBufferSink = true;
            if (this.bufferSink != null) {
                this.getSinkMethods();
            }
            if (this.copyMask == null || this.copyMask.equals("")) {
                this.initCopyMask();
            }
            String string3 = string + string2 + ", " + this.copyMask;
            this.natSink = new BufferDataAppSink("nat", string3, new BufferDataAppSink.Listener(){

                public void bufferFrame(int n, int n2, Buffer buffer) {
                    Capture.this.invokeEvent(n, n2, buffer);
                }
            });
            this.natSink.setAutoDisposeBuffer(false);
            this.pipeline.addMany(new Element[]{this.sourceElement, this.natSink});
            Element.linkMany((Element[])new Element[]{this.sourceElement, this.natSink});
        } else {
            Element element = ElementFactory.make((String)"ffmpegcolorspace", (String)"ColorConverter");
            Element element2 = ElementFactory.make((String)"capsfilter", (String)"ColorFilter");
            element2.setCaps(new Caps("video/x-raw-rgb, width=" + this.reqWidth + ", height=" + this.reqHeight + ", bpp=32, depth=24" + string2));
            this.rgbSink = new RGBDataAppSink("rgb", new RGBDataAppSink.Listener(){

                public void rgbFrame(int n, int n2, IntBuffer intBuffer) {
                    Capture.this.invokeEvent(n, n2, intBuffer);
                }
            });
            this.rgbSink.setPassDirectBuffer(Video.passDirectBuffer);
            this.pipeline.addMany(new Element[]{this.sourceElement, element, element2, this.rgbSink});
            Element.linkMany((Element[])new Element[]{this.sourceElement, element, element2, this.rgbSink});
        }
        this.pipelineReady = true;
        this.newFrame = false;
    }

    protected void setEventHandlerObject(Object object) {
        this.eventHandler = object;
        try {
            this.captureEventMethod = object.getClass().getMethod("captureEvent", Capture.class);
            return;
        }
        catch (Exception exception) {
            try {
                this.captureEventMethod = object.getClass().getMethod("captureEvent", Object.class);
                return;
            }
            catch (Exception exception2) {
                return;
            }
        }
    }

    protected synchronized void invokeEvent(int n, int n2, IntBuffer intBuffer) {
        this.available = true;
        this.bufWidth = n;
        this.bufHeight = n2;
        if (this.copyPixels == null) {
            this.copyPixels = new int[n * n2];
        }
        intBuffer.rewind();
        try {
            intBuffer.get(this.copyPixels);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            bufferUnderflowException.printStackTrace();
            this.copyPixels = null;
            return;
        }
        this.fireCaptureEvent();
    }

    protected synchronized void invokeEvent(int n, int n2, Buffer buffer) {
        this.available = true;
        this.bufWidth = n;
        this.bufHeight = n2;
        if (this.natBuffer != null) {
            this.natBuffer.dispose();
        }
        this.natBuffer = buffer;
        this.fireCaptureEvent();
    }

    private void fireCaptureEvent() {
        if (this.captureEventMethod != null) {
            try {
                this.captureEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception exception) {
                System.err.println("error, disabling captureEvent()");
                exception.printStackTrace();
                this.captureEventMethod = null;
            }
        }
    }

    protected float getSourceFrameRate() {
        for (Element element : this.pipeline.getSinks()) {
            for (Pad pad : element.getPads()) {
                Fraction fraction = org.gstreamer.Video.getVideoFrameRate((Pad)pad);
                if (fraction == null) continue;
                return (float)fraction.toDouble();
            }
        }
        return 0.0f;
    }

    protected String getName(String string) {
        String[] stringArray;
        String string2 = "";
        for (String string3 : stringArray = PApplet.split((String)string, (char)',')) {
            String[] stringArray2;
            if (-1 >= string3.indexOf("name") || 0 >= (stringArray2 = PApplet.split((String)string3, (char)'=')).length) continue;
            string2 = stringArray2[1];
        }
        return string2;
    }

    protected int[] getSize(String string) {
        String[] stringArray;
        int[] nArray = new int[]{0, 0};
        for (String string2 : stringArray = PApplet.split((String)string, (char)',')) {
            String[] stringArray2;
            String[] stringArray3;
            if (-1 >= string2.indexOf("size") || 0 >= (stringArray3 = PApplet.split((String)string2, (char)'=')).length || (stringArray2 = PApplet.split((String)stringArray3[1], (char)'x')).length != 2) continue;
            nArray[0] = PApplet.parseInt((String)stringArray2[0]);
            nArray[1] = PApplet.parseInt((String)stringArray2[1]);
        }
        return nArray;
    }

    protected String getFrameRate(String string) {
        String[] stringArray;
        String string2 = "";
        for (String string3 : stringArray = PApplet.split((String)string, (char)',')) {
            String[] stringArray2;
            if (-1 >= string3.indexOf("fps") || 0 >= (stringArray2 = PApplet.split((String)string3, (char)'=')).length || (string2 = stringArray2[1]).indexOf("/") != -1) continue;
            string2 = string2 + "/1";
        }
        return string2;
    }

    public void setBufferSink(Object object) {
        this.bufferSink = object;
        this.initCopyMask();
    }

    public void setBufferSink(Object object, String string) {
        this.bufferSink = object;
        this.copyMask = string;
    }

    public boolean hasBufferSink() {
        return this.bufferSink != null;
    }

    public synchronized void disposeBuffer(Object object) {
        ((Buffer)object).dispose();
    }

    protected void getSinkMethods() {
        try {
            this.sinkCopyMethod = this.bufferSink.getClass().getMethod("copyBufferFromSource", Object.class, ByteBuffer.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception exception) {
            throw new RuntimeException("Capture: provided sink object doesn't have a copyBufferFromSource method.");
        }
        try {
            this.sinkSetMethod = this.bufferSink.getClass().getMethod("setBufferSource", Object.class);
            this.sinkSetMethod.invoke(this.bufferSink, new Object[]{this});
        }
        catch (Exception exception) {
            throw new RuntimeException("Capture: provided sink object doesn't have a setBufferSource method.");
        }
        try {
            this.sinkDisposeMethod = this.bufferSink.getClass().getMethod("disposeSourceBuffer", new Class[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Capture: provided sink object doesn't have a disposeSourceBuffer method.");
        }
        try {
            this.sinkGetMethod = this.bufferSink.getClass().getMethod("getBufferPixels", int[].class);
        }
        catch (Exception exception) {
            throw new RuntimeException("Capture: provided sink object doesn't have a getBufferPixels method.");
        }
    }

    protected void initCopyMask() {
        this.copyMask = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "red_mask=(int)0xFF000000, green_mask=(int)0xFF0000, blue_mask=(int)0xFF00" : "red_mask=(int)0xFF, green_mask=(int)0xFF00, blue_mask=(int)0xFF0000";
    }

    public synchronized void post() {
        if (this.useBufferSink && this.sinkDisposeMethod != null) {
            try {
                this.sinkDisposeMethod.invoke(this.bufferSink, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static {
        if (PApplet.platform == 2) {
            sourceElementName = "qtkitvideosrc";
            devicePropertyName = "device-name";
            indexPropertyName = "device-index";
        } else if (PApplet.platform == 1) {
            sourceElementName = "ksvideosrc";
            devicePropertyName = "device-name";
            indexPropertyName = "device-index";
        } else if (PApplet.platform == 3) {
            sourceElementName = "v4l2src";
            devicePropertyName = "device";
            indexPropertyName = "device-fd";
        }
        useResMacHack = true;
    }
}

