/**
 * Dessin-typo / Poème mobile / Il pleure sur la ville - Paul Verlaine 
 * 
 * Le sketch devient un espace d'expression, à l'aide de la souris, 
 * où la typo s'anime et se revèle. 
 * 
 * RACCOURCIS CLAVIER
 * del, backspace : effacer écran
 * flèche du haut : angle distortion +
 * flèche du bas  : angle distortion -
 * Clavier - S : enregistrer en png

 */

float x = 0, y = 0;
float stepSize = 5.0;
String letters = "Il pleure dans mon coeur, Paul Verlaine, Romances sans paroles (1874) Il pleure dans mon cœur comme il pleut sur la ville; Quelle est cette langueur qui pénètre mon cœur ? Ô bruit doux de la pluie par terre et sur les toits ! Pour un cœur qui s'ennuie, Ô le chant de la pluie ! Il pleure dans raison dans ce cœur qui s'écœeure. Quoi ! nulle trahison ?… Ce dueil est sans raison. C'est bien la pire peine de ne savoir pourquoi, sans amour et sans haine, mon cœur a tant de peine !";

//String[] letters ;
int fontSizeMin = 3;
float angleDistortion = 0.0;
int counter = 0;

// font 
PFont maFont;
String[]typo;
String cheminTypo; // chemin d'acces de la typo

void setup() {
  // use full screen size 
  size(1280, 800);
  background(255);
  smooth();
  cursor(HAND);
 
  x = mouseX;
  y = mouseY;
  
  // font
  // créer la font
   //importation typo
  typo = loadStrings("typo.txt"); // charge le nom des typos
  
  // debug
  println("les typos sont :" + typo);
  println("");
 
 }

void draw() {
  if (mousePressed) {
    float d = dist(x,y, mouseX,mouseY); // distance entre l'ancienne position de la souris et la nouvelle position
    textSize(fontSizeMin+d/2);
    char newLetter = letters.charAt(counter); // choix d'une lettre à la position "counter" du texte contenu dans la String letters
    stepSize = textWidth(newLetter);

    if (d > stepSize) { // si la distance d est dupérieure à stepSize (initialement 5pixels)
      float angle = atan2(mouseY-y, mouseX-x); // Calcul de l'angle entre l'axe horizontal et le vecteur déplacement de la souris entre deux points consécutifs

      pushMatrix(); // 
        translate(x, y);
        rotate(angle + random(angleDistortion)); // création d'un angle d'écriture de la lettre aléatoire autour de l'angle "angle"
        
        // choix aléatoire de la typo
        // indice  aléatoire i pour choisir une typo
        int i = floor(random(0, typo.length));
        maFont= createFont(typo[i], 40); // charger la typo
        textFont(maFont);
        textAlign(LEFT);
        fill(0);
        
        // debug : nom de la typo choisie
        println("i=" + i + " counter ="+ counter + " typo=" + typo[i]);
        
        // écriture de la lettre
        text(newLetter, 0, 0); // dessin de la lettre sur la fenêtre d'affichage avec une taille stepSize et un angle par rapport à l'horizontal angle + alpha
      popMatrix();

      counter++; // counter = (counter+1)%(letters.length -1);
      /* si le compteur est supérieur à la taille de la chaine de charactère letters, remettre le compteur à zéro */
     if (counter > letters.length()-1) counter = 0; 
      
      //calcul de la nouvelle position de la position de la lettre en fonction de la position de la souris
      x = x + cos(angle) * stepSize;
      y = y + sin(angle) * stepSize; 
    }
  }
}

void mousePressed() {
  x = mouseX;
  y = mouseY;
}

void keyTyped() {
  if (key == 's' || key == 'S') save("P_2_3_3_01.png");
}

void keyPressed() {
  // angle de "distortion" en fonction des touches haut-bas
  if (key == CODED){
    if (keyCode == DELETE || keyCode == BACKSPACE) background(255);
    if (keyCode == UP) angleDistortion += 0.1;
    if (keyCode == DOWN) angleDistortion -= 0.1; 
  }
}