/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.Environment;
import com.sun.deploy.ref.Helpers;
import com.sun.deploy.security.SecureStaticVersioning;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.SystemUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class DeploymentHooks {
    static boolean usageTrackerFailed = false;
    Object usageTracker;
    Method runMethod;
    String storedAppName = null;
    String storedArg1 = null;
    String storedArg2 = null;

    private boolean initialize() {
        if (usageTrackerFailed) {
            return false;
        }
        if (this.runMethod == null) {
            try {
                Class<?> clazz = Class.forName("sun.usagetracker.UsageTrackerClient", true, null);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                this.usageTracker = constructor.newInstance(new Object[0]);
                this.runMethod = clazz.getMethod("run", String.class, String.class);
            }
            catch (Throwable throwable) {
                usageTrackerFailed = true;
                return false;
            }
        }
        return true;
    }

    public synchronized void storeAppName(String string) {
        this.storedAppName = string;
    }

    private synchronized String getAndClearAppName() {
        String string = this.storedAppName;
        this.storedAppName = null;
        return string;
    }

    public synchronized void trackUsage(AppInfo appInfo, DeploymentRuleSet deploymentRuleSet) {
        if (!this.initialize()) {
            return;
        }
        String string = this.getAndClearAppName();
        if (string == null) {
            return;
        }
        try {
            String string2;
            String string3 = null;
            if (Environment.isOldPlugin()) {
                string3 = "plugin";
            } else if (Environment.isJavaPlugin()) {
                string3 = Environment.isJavawsAppletLifecycle() ? "javaws applet" : "plugin2";
            } else if (Environment.isJavaWebStart()) {
                string3 = "javaws application";
            }
            if (deploymentRuleSet.isRuleBlock()) {
                string3 = string3 + " denied";
                if (deploymentRuleSet.getMessage() != null) {
                    string3 = string3 + " [" + deploymentRuleSet.getMessage() + "]";
                }
            } else if (deploymentRuleSet.isRuleRun()) {
                string2 = deploymentRuleSet.getVersionString();
                string3 = string2 == null || SecureStaticVersioning.satisfiesDRSVersion(string2) ? string3 + " permitted" : string3 + " denied [required version " + string2 + " not available]";
            }
            string2 = Helpers.storeAppModelToString(appInfo.getAppModel());
            String string4 = deploymentRuleSet.getCustomerString();
            string = string + " app_model=" + string2;
            if (string4 != null) {
                Trace.println("customer string in Main DRS used is:\n" + string4, TraceLevel.RULESET);
                string = string + " app_customer=" + SystemUtils.encodeString(string4);
            }
            this.storedArg1 = string3;
            this.storedArg2 = string;
        }
        catch (Throwable throwable) {
            Trace.println("Error invoking UsageTracker:", TraceLevel.BASIC);
            Trace.ignored(throwable);
        }
    }

    public synchronized void confirmAppRun() {
        this.confirm(this.storedArg1, this.storedArg2);
        this.storedArg2 = null;
        this.storedArg1 = null;
    }

    public synchronized void confirmAppDenied(DeploymentRuleSet deploymentRuleSet) {
        this.confirm(this.storedArg1 + " denied [by user]", this.storedArg2);
        this.storedArg2 = null;
        this.storedArg1 = null;
    }

    public synchronized void confirmAppBlocked(DeploymentRuleSet deploymentRuleSet) {
        String string = this.storedArg1;
        if (!deploymentRuleSet.isRuleBlock() && !deploymentRuleSet.isRuleRun()) {
            string = string + " denied [by security settings]";
        }
        this.confirm(string, this.storedArg2);
        this.storedArg2 = null;
        this.storedArg1 = null;
    }

    private void confirm(String string, String string2) {
        try {
            if (string != null && string2 != null) {
                Object[] objectArray = new Object[]{string, string2};
                this.runMethod.invoke(this.usageTracker, objectArray);
                Trace.println("JUT Record:\n    " + string + "\n    " + string2, TraceLevel.SECURITY);
            }
        }
        catch (Throwable throwable) {
            Trace.println("Error invoking UsageTracker:", TraceLevel.BASIC);
            Trace.ignored(throwable);
        }
    }
}

