/*
références : https://forum.processing.org/one/topic/converting-string-to-int.html
 */

import processing.serial.*;

Serial myPort;  // Create object from Serial class
String  inBuffer;      // Data received from the serial port

void setup() {
  size(200, 200);
  // I know that the first port in the serial list on my mac
  // is always my  FTDI adaptor, so I open Serial.list()[0].
  // On Windows machines, this generally opens COM1.
  // Open whatever port is the one you're using.

  // Print a list of the serial ports, for debugging purposes:
  printArray(Serial.list());

  String portName = Serial.list()[32];
  myPort = new Serial(this, portName, 9600);
}

void draw() {
  if ( myPort.available() > 0) {  // If data is available,
    inBuffer = myPort.readString();         // read it and store it in val
  }
  if (inBuffer != null) {
    println("inBuffer="+inBuffer);
    int a=int(inBuffer);
    println("a="+a);
  }
}
