
/*
  Stepper Motor Control - one revolution

  This program drives a unipolar or bipolar stepper motor.
  The motor is attached to digital pins 8 - 11 of the Arduino.

  The motor should revolve one revolution in one direction, then
  one revolution in the other direction.

*/

#include <Stepper.h>

const int stepsPerRevolution = 64;  // change this to fit the number of steps per revolution
// for your motor

// initialize the stepper library on pins 8 through 11:
Stepper myStepper(stepsPerRevolution, 8, 9, 10, 11);

int compteurLoop = 0, tour = 2048, nbTour = 2; // 1 tour représente 2048 pas du moteur
unsigned long timer0 = 0;

void setup() {
  // set the speed at N steps/s:
  myStepper.setSpeed(200);
  // initialize the serial port:
  Serial.begin(9600);
}

void loop() {
  // step one revolution  in one direction:
  if (compteurLoop == 0) {
    timer0 = millis();
  }

  // step one revolution  in one direction:
  //Serial.println("clockwise");
  timer0 = millis(); // lancer chrono
  myStepper.step(nbTour * tour); // effectuer nbTour=2 tours c'est à dire 2*2048 pas

  unsigned long t = (millis() - timer0);
  Serial.print("Période : ");
  Serial.print(t/2);
  Serial.println("ms");
  delay(500);

  // step one revolution in the other direction:
  //Serial.println("counterclockwise");
  timer0 = millis(); // lancer chrono
  myStepper.step(-nbTour * tour); // effectuer 1 tour et demi en sens inverse, c'est à dire 1.5*2048 pas
  t = (millis() - timer0);
  Serial.print("Période : ");
  Serial.print(t/2);
  Serial.println("ms");
  delay(500);
}
