#include <SoftwareSerial.h>
SoftwareSerial hc06(2, 3);
String cmd = "";
float sensor_val = 0;
// faire clignoter clignoter la led
byte led = 13;
int Tblink = 100;
float isBlink = false; // drapeau pour lancer le clignotement... ou non


void setup() {
  // pin 13 OUTPUT
  pinMode(led, OUTPUT);

  //Initialize Serial Monitor
  Serial.begin(9600);
  //Initialize Bluetooth Serial Port
  hc06.begin(9600);
}
void loop() {
  //Read data from HC06
  while (hc06.available() > 0) {
    cmd += (char)hc06.read();
  }
  //Select function with cmd
  if (cmd != "") {
    Serial.print("Command recieved : ");
    Serial.println(cmd);
    // We expect ON or OFF from bluetooth
    if (cmd == "ON") {
      Serial.println("Function is on");
      digitalWrite(13, HIGH); // alumer la led
      isBlink = false; // arrêter le clignotement
    } else if (cmd == "OFF") {
      Serial.println("Function is off");
      digitalWrite(13, LOW); // éteindre la led
      isBlink = false; // arrêter le clignotement
    } else {
      // convertir la comande en un entier
      int x = cmd.toInt(); // conversion de la chaine de caractère en un entier
      if (x >= 0 && x <= 10000) { // si la commande est un nombre entre 0 et 10000 (soit 10s)
        Tblink = x;
        clignoterLed(13, x, x);
        isBlink=true;
      }
      else {
        Serial.println("Function is off by default");
      }
    }
    cmd = ""; //reset cmd
  }
  // gestion du clignotement
  if (isBlink) {
    clignoterLed(led,Tblink,Tblink);
  }

  // Simulate sensor measurement
  sensor_val = (float)random(256); // random number between 0 and 255

  //Write sensor data to HC06
  hc06.print(sensor_val);
  delay(100);
}
