/**
 * Simple Read
 * 
 * Read data from the serial port and change the color of a rectangle
 * when a switch connected to a Wiring or Arduino board is pressed and released.
 * This example works with the Wiring / Arduino program that follows below.
 */


import processing.serial.*;

Serial myPort;  // Create object from Serial class
String DonneesString = ""; // donnée envoyée par la carte Arduino au format String
float val;      // Data received from the serial port
boolean firstContact = false;        // Whether we've heard from the microcontroller

// paramètres d'enregistrement
boolean record=true; // enregistrement des données initialement actif
Table t;// tableau de donnés

void setup() 
{
  size(200, 200);
  // affichage des données
  textSize(26); 

  // I know that the first port in the serial list on my mac
  // is always my  FTDI adaptor, so I open Serial.list()[0].
  // On Windows machines, this generally opens COM1.
  // Open whatever port is the one you're using.
  // Print a list of the serial ports, for debugging purposes:
  printArray(Serial.list());

  String portName = Serial.list()[1];
  myPort = new Serial(this, portName, 9600);
  myPort.bufferUntil('\n');

  // création du tableau avec deux colonnes : x et y
  t = new Table();
  t.addColumn("val");
}

void draw() {
  fill(128);
  rect(0, 0, width, height);
  fill(255);
  text(val, 50, 50);
}

void serialEvent(Serial myPort) {
  if (record) {// si l'enregistrement est actif 
    String inString = myPort.readStringUntil('\n'); // lire la valeur sur le port série
    //debug
    //print(inString);

    //if (DonneesString != null) {
    //  inString = trim(inString); // enlève les caractères "espace" au début et à la fin d'une String
    //}

    val = float(inString); 
    // debug
    //println(val);

    // enregistrer les valeurs dans le tableau "t"
    TableRow newRow = t.addRow();
    newRow.setFloat("val", val);
  }
}

void keyPressed() {// enregistrement des données
  if (key==ENTER) {
    saveTable(t, "data/donees.csv");
    println("Table donees.csv enregistrée au format .cvs, contenant : "+ t.getRowCount() + " valeurs");
    noLoop();
    record = false; // fin de l'enregistrement
  }
}
