// Code de  Jacob Seidelin (https://www.nihilogic.dk/labs/jsascii/)
//Modifié par Andrei Gheorghe (https://github.com/idevelop)
//remodifié et expliqué par Lookitsgraphic ( https://lookitsgraphic.com/Projects/Ascii.html/ ) 

//variable fenetre taille 
var w = window.innerWidth 
|| document.documentElement.clientWidth //faire appel à la mesure écran de l'ordinateur (largeur)
|| document.body.clientWidth;

var h = window.innerHeight
|| document.documentElement.clientHeight //faire appel à la mesure écran de l'ordinateur (hauteur)
|| document.body.clientHeight;

(function() {
	var asciiContainer = document.getElementById("ascii"); //faire appel au code ascii.js
	var capturing = false; 

	camera.init({ //faire démarer la camera
		width: (w/7), //utilise variable taille
		height: (h/5.2), //utilise variable taille
		fps: 25,//nombre image par seconde
		mirror: true, //fonction mirroir dans camera, changer par false pour une rotation verticale

		onFrame: function(canvas) {
			ascii.fromCanvas(canvas, {
				// contraste: 128,
				callback: function(asciiString) {
					asciiContainer.innerHTML = asciiString;
				}
			});
		},

		onSuccess: function() { //lorsque l'activation caméra fonctionne
			document.getElementById("info").style.display = "none"; //faire disparaitre le message active ta caméra

			const button = document.getElementById("button"); //si on appuis sur le bouton
			button.style.display = "block";
			button.onclick = function() {
				if (capturing) {
					camera.pause();
					button.innerText = 'resume';
				} else {
					camera.start();
					button.innerText = 'pause';
				}
				capturing = !capturing;
			};
		},

		onError: function(error) {
			// TO DO: Envoi un message d'erreur vers le gestionnaire d'erreurs défini
		},

		onNotSupported: function() { //si la caméra ne fonctionne pas.
			document.getElementById("info").style.display = "none"; //remplacer l'élément <h6 id="info"> par ne fonctionne pas
			asciiContainer.style.display = "none";
			document.getElementById("notSupported").style.display = "block";//faire apparaitre le message à l'écran
		}
	});
})();