// Code de  Jacob Seidelin (https://www.nihilogic.dk/labs/jsascii/)
//Modifié par Andrei Gheorghe (https://github.com/idevelop)
//remodifié et expliqué par Lookitsgraphic ( https://lookitsgraphic.com/Projects/Ascii.html/ ) 

var ascii = (function() { //créer variable ascii
	function asciiFromCanvas(canvas, options) { //utilisant canvas et option


		var characters = (" .:-/*0#8%@").split(""); //Variable d'utilisation des caractères, sans aucune séparations. on peut remplacer la chaine de caratères par d'autres. si on travaille sur fond blanc mieux vaut privilégier les caractères allant du plus petit au plus gros, sinon inverse, on peut en ajouter et en supprimer.

		var context = canvas.getContext("2d"); //variable créant la zone écran rectangulaire
		var canvasWidth = canvas.width; //variable utilisant la largeur caméra 
		var canvasHeight = canvas.height;// variable utilisant la hauteur caméra
		
		var asciiCharacters = "";

		// Variable calculant le contraste / tuto: 
		// https://www.dfstudios.co.uk/articles/image-processing-algorithms-part-5/
		var contrastFactor = (259 * (options.contrast + 255)) / (255 * (259 - options.contrast));

		var imageData = context.getImageData(0, 0, canvasWidth, canvasHeight);
		for (var y = 0; y < canvasHeight; y += 2) { // récupérer un pixel sur deux sur la hauteur car caractères pas carré
			for (var x = 0; x < canvasWidth; x++) {
				// obtenir la luminosité de chaque pixel et afficher le caractère correspondant

				var offset = (y * canvasWidth + x) * 4;

				var color = getColorAtOffset(imageData.data, offset); //variable pour calcul couleur
	
				// Variable accentuant le contraste de l'image pour que chaque caractères se démarquent / tuto : 
				// https://www.dfstudios.co.uk/articles/image-processing-algorithms-part-5/
				var contrastedColor = {
					red: bound(Math.floor((color.red - 128) * contrastFactor) + 128, [0, 255]),
					green: bound(Math.floor((color.green - 128) * contrastFactor) + 128, [0, 255]),
					blue: bound(Math.floor((color.blue - 128) * contrastFactor) + 128, [0, 255]),
					alpha: color.alpha
				};

				// Calculer la luminosité de chaque pixels / question tuto  : 
				// https://stackoverflow.com/questions/596216/formula-to-determine-brightness-of-rgb-color
				var brightness = (0.299 * contrastedColor.red + 0.587 * contrastedColor.green + 0.114 * contrastedColor.blue) / 255;

				var character = characters[(characters.length - 1) - Math.round(brightness * (characters.length - 1))];

				asciiCharacters += character;
			}

			asciiCharacters += "\n"; //Le \n est utilisé pour trouver une retour ligne de caractères.


		}

		options.callback(asciiCharacters); //à chaque fin d eligne pixel, retour ligne.
	}

	function getColorAtOffset(data, offset) { // implémenter la couleur par couche 
		return {
			red: data[offset],
			green: data[offset + 1],
			blue: data[offset + 2],
			alpha: data[offset + 3]
		};
	}

	function bound(value, interval) { // 
		return Math.max(interval[0], Math.min(interval[1], value));
	}

	return {
		fromCanvas: function(canvas, options) {
			options = options || {};
			options.contrast = (typeof options.contrast === "undefined" ? 128 : options.contrast);
			options.callback = options.callback || doNothing;

			return asciiFromCanvas(canvas, options);
		}
	};
})();