/**  Affiche tactile interactive - 
*  Quand on appuie sur une touche, cela lance une image, une vidéo, une annim, un son, etc...
*/
/// librairies
import processing.sound.*;
import gohai.glvideo.*;


// variables globales
PImage im; // une image
SoundFile son; // un son
GLMovie vid; // une vidéo

// bouton son image active ?
boolean image_active = false;

// bouton son actif ?
boolean son_actif = false;
float tempsDebutSon = 0; // temps du début de la musique a été joué

// bouton video active ?
boolean video_active = false;
   
void setup() {
  size(500, 500);
  noStroke();
  background(0);
  
  // initialisation des variables globales
  im = loadImage("images/chien.jpg");
  
  // chargement du son
  son = new SoundFile(this, "sons/beat.aiff");
  //println(son.duration());
  
  // chargement de la video
  vid = new GLMovie(this, "videos/affiche.mp4"); 
 
}

void draw() { 
 
  // gestion du son ////////////////////////////////////////
  // test du temps pendant lequel le son est joué
  //debug
  println("son_actif = "+ son_actif);
  // fin debug
  
  if (son_actif){
    float tempsEcoute = millis() - tempsDebutSon ;

   // debug 
    println("tempsDebutSon = " + tempsDebutSon);
    println("tempsEcoute = " + tempsEcoute);
    println("durée du son " + son.duration());
    // fin debug
    
    if ( tempsEcoute >= son.duration()*1000){ // si le son est fini
      son_actif = false; // bouton son_actif off
    }
  }
  
    // gestion de la vidéo ////////////////////////////////////////
    if (video_active){
      image(vid, 0, 0, width, height);
    }
    else{
      background(0); // fond noir
    }
     
     // gestion de l'image
     if (image_active){
       float x = 30 + random(-20,20); // random sur la position
       float y = 30 + random(-20,20);
       image(im,x,y,200,200);
     }
  
}

void keyPressed() {
  if (key == CODED) {
    if (keyCode == RIGHT) { // son
      if (son_actif==false){ // le son ne joue pas
        // arrêter l'autre son qui tourne éventuellement
        son.stop();
        // chargement du son 1
        son = new SoundFile(this, "sons/beat.aiff");
        son.play();
        tempsDebutSon = millis();
        son_actif = true; // bouton son_actif on
      }
      else { // le son joue
        son.stop();
        son_actif = false;
      }
    }
    if (keyCode == LEFT) { // son 2
      if (son_actif==false){ // le son ne joue pas
        // arrêter l'autre son qui tourne éventuellement
        son.stop();
        // chargement du son 1
        son = new SoundFile(this, "sons/Armstrong.wav");
        son.play();
        tempsDebutSon = millis();
        son_actif = true; // bouton son_actif on
      }
      else { // le son joue
        son.stop();
        son_actif = false;
      }
    }
    
    if (keyCode == UP) { // video 1
      if (video_active == false){ // la vidéo 1 ne tourne pas
        // chargement de la video 1
        vid = new GLMovie(this, "videos/affiche.mp4");
        vid.loop();
        video_active = true;
      }
      else{
        //vid.stop();
        clear();
        video_active = false;
      }
    } 
    
    if (keyCode == DOWN) { // video 2
      if (video_active == false){ // la vidéo 2 ne tourne pas
       // chargement de la video 2
        //vid = new Movie(this, "videos/transit.mov");
        vid = new GLMovie(this, "videos/ArmstrongAlunissage.mp4");
        vid.loop();
        video_active = true;
      }
      else{
        //vid.stop();
        clear();
        video_active = false;
      }
    }
  }
  if (key == ' ') { // image
      image_active = !image_active;
   } 
}