// Daniel Shiffman
// Tracking the average location beyond a given depth threshold
// Thanks to Dan O'Sullivan

// https://github.com/shiffman/OpenKinect-for-Processing
// http://shiffman.net/p5/kinect/

import org.openkinect.freenect.*;
import org.openkinect.processing.*;

// The kinect stuff is happening in another class
KinectTracker tracker;
Kinect kinect;

// dessin
PVector anciennePosition;
int compteurFrames = 0;


void setup() {
  size(640, 520);
  // initialisation var. Glob.
  kinect = new Kinect(this);
  tracker = new KinectTracker();
  anciennePosition = new PVector(0, 0);
}

void draw() {
  //background(255);

  // Run the tracking analysis
  tracker.track();
  // Show the image
  //tracker.display();

  // Rond Rouge
  // Let's draw the raw location RED
  PVector v1 = tracker.getPos();
  fill(#FC0808);
  noStroke();
  ellipse(v1.x, v1.y, 20, 20);

  // dessin d'une ligne brisée
  if (compteurFrames > 3 ) { //compteurFrames > 3 : on me prend pas en compte les 1ers points
    strokeWeight(2);
    stroke(255, 255, 0);
    line(anciennePosition.x, anciennePosition.y, v1.x, v1.y);
    // mémorisation de la nouvelle position
    anciennePosition = v1;
  }


  // Info Profondeur
  // Display some info
  int t = tracker.getThreshold();
  fill(0);
  text("threshold: " + t + "    " +  "framerate: " + int(frameRate) + "    " + 
    "UP increase threshold, DOWN decrease threshold", 10, 500);
    
  // incrémentation du compteur de frames
  compteurFrames++;
  println("compteurFrames = "+compteurFrames);
}

// Adjust the threshold with key presses
// réglage profondeur de champ
void keyPressed() {
  int t = tracker.getThreshold();
  if (key == CODED) {
    if (keyCode == UP) {
      t+=5;
      tracker.setThreshold(t);
    } else if (keyCode == DOWN) {
      t-=5;
      tracker.setThreshold(t);
    }
  }
}
