/**  Objet interactif - 
On reçoit une donnée du port série, on teste la valeur de cette donnée,
 cela lance une image, une vidéo, une annim, un son, etc...
 */
 
/// librairies
import processing.sound.*;
import processing.video.*; 
import processing.serial.*;


// variables globales
PImage im; // une image
SoundFile son; // un son - un seul lecteur CD audio
Movie vid; // une vidéo - un seul lecteur DVD vidéo

// bouton image active ? // est-ce que l'image est active ? Si oui, on affiche l'image
boolean animation_active = false; // true ou false (2 valleurs possibles) => 1 bit (0 ou 1)

// bouton son actif ?
boolean son_actif = false;
float tempsDebutSon = 0; // temps du début de la musique a été joué

// bouton video active ?
boolean video_active = false;

/// dialogue avec la carte Arduino
Serial myPort;  // Create object from Serial class
String  inBuffer;      // Data received from the serial port
int donneePortSerie; // entier converti de la chaine de caractère reçue sur le port série

// seuil de détection
float seuil = 25; // distance de seuil = 25cm


void setup() { // initialisation des paramètres d'affichage & chargement des sons, vidéos, etc.
  size(500, 500);
  noStroke();
  background(0);

  // initialisation des variables globales
  im = loadImage("images/chien.jpg");

  // chargement du son
  son = new SoundFile(this, "sons/beat.aiff");
  //println(son.duration());

  // chargement de la video
  vid = new Movie(this, "videos/affiche.mp4");

  /// Port série
  // Print a list of the serial ports, for debugging purposes:
  printArray(Serial.list());

  String portName = Serial.list()[0];
  myPort = new Serial(this, portName, 9600);
}

void draw() {
  // lecture des données sur le port série : 
  lectureDonneePortSerie();

  // test des données lues sur le port série et choix de l'interactivité (vidéo, son, animation)
  // choisir le média à lancer :
  // son
  //gestionSon("sons/beat.aiff"); 
  // video
  gestionVideo("videos/ArmstrongAlunissage.mp4"); // "videos/affiche.mp4"
  // animation
  gestionAnimation();
  
  // affichage de la vidéo ////////////////////////////////////////
  if (video_active) {
    image(vid, 0, 0, width, height);
  } else {
    background(0); // fond noir
  }
  // affichage de l'animation//////////////////////////////////////
  if (animation_active) {
    lancerAnimation();
  }
}
////////////////////////////////////// Méthodes ///////////////////////////////
void movieEvent(Movie movie) { //// gestion de la vidéo
  vid.read();
}
